/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Registry;

import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class StackTypeRegistry {
    private static final Map<ResourceLocation, IStackType<?>> TYPES = new HashMap();

    public static <T> void registerType(IStackType<T> type) {
        if (TYPES.containsKey(type.getTypeId())) {
            throw new IllegalStateException("Duplicate stack type registration: " + String.valueOf(type.getTypeId()));
        }
        TYPES.put(type.getTypeId(), type);
    }

    public static <T> IStackType<T> getType(ResourceLocation id) {
        IStackType<?> type = TYPES.get(id);
        if (type == null) {
            throw new IllegalArgumentException("Unknown stack type: " + String.valueOf(id));
        }
        return type;
    }

    public static List<IStackType<?>> getAllTypes() {
        return List.copyOf(TYPES.values());
    }
}

