/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase;

import com.wintercogs.beyonddimensions.Api.DataBase.NetPermissionlevel;
import com.wintercogs.beyonddimensions.Api.DataBase.PlayerPermissionInfo;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Item.ModItems;
import com.wintercogs.beyonddimensions.Unit.PlayerNameHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DimensionsNet
extends SavedData {
    private int id;
    public boolean deleted = false;
    private UUID owner;
    private final Set<UUID> managers = new HashSet<UUID>();
    private final Set<UUID> players = new HashSet<UUID>();
    private UnifiedStorage unifiedStorage = new UnifiedStorage(this);
    private final boolean temporary;
    private int currentTime = 12000;
    private int holdTime = 12000;

    public DimensionsNet(boolean temporary) {
        MinecraftForge.EVENT_BUS.addListener(this::onServerTick);
        this.temporary = temporary;
    }

    public static DimensionsNet create() {
        return new DimensionsNet(false);
    }

    public static DimensionsNet createNewNetForPlayer(Player player, long defaultSlotCapability, int defaultSlotMaxSize) {
        DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
        if (net == null) {
            String netId = DimensionsNet.buildNewNetName(player.m_20194_());
            String numId = netId.replace("BDNet_", "");
            DimensionsNet newNet = (DimensionsNet)player.m_20194_().m_129880_(Level.f_46428_).m_8895_().m_164861_(DimensionsNet::load, DimensionsNet::create, netId);
            newNet.setId(Integer.parseInt(numId));
            newNet.setOwner(player.m_20148_());
            newNet.addManager(player.m_20148_());
            newNet.addPlayer(player.m_20148_());
            newNet.m_77762_();
            newNet.unifiedStorage.setSlotCapacity(defaultSlotCapability);
            newNet.unifiedStorage.setSlotMaxSize(defaultSlotMaxSize);
            return newNet;
        }
        return net;
    }

    public static String buildNewNetName(MinecraftServer dataProvider) {
        int netId;
        for (netId = 0; netId < 10000 && dataProvider.m_129880_(Level.f_46428_).m_8895_().m_164858_(DimensionsNet::load, "BDNet_" + netId) != null; ++netId) {
        }
        return "BDNet_" + netId;
    }

    @Nullable
    public static DimensionsNet getNetFromId(int id, MinecraftServer dataProvider) {
        if (id < 0) {
            return null;
        }
        DimensionsNet net = (DimensionsNet)dataProvider.m_129880_(Level.f_46428_).m_8895_().m_164858_(DimensionsNet::load, "BDNet_" + id);
        if (net != null && !net.deleted) {
            return net;
        }
        return null;
    }

    @Nullable
    public static DimensionsNet getNetFromPlayer(Player player) {
        for (int netId = 0; netId < 10000; ++netId) {
            DimensionsNet net = (DimensionsNet)player.m_20194_().m_129880_(Level.f_46428_).m_8895_().m_164858_(DimensionsNet::load, "BDNet_" + netId);
            if (net == null || net.deleted || !net.players.contains(player.m_20148_())) continue;
            return net;
        }
        return null;
    }

    public static DimensionsNet load(CompoundTag tag) {
        CompoundTag energyTag;
        UUID owner;
        DimensionsNet net = new DimensionsNet(false);
        net.id = tag.m_128451_("Id");
        UUID uUID = owner = tag.m_128403_("Owner") ? tag.m_128342_("Owner") : null;
        if (owner != null) {
            net.owner = owner;
        }
        net.unifiedStorage.deserializeNBT(tag.m_128469_("UnifiedStorage"));
        if (tag.m_128441_("EnergyStorage") && (energyTag = tag.m_128469_("EnergyStorage")).m_128441_("Energy")) {
            net.unifiedStorage.insert(new EnergyStackType(energyTag.m_128454_("Energy")), false);
        }
        if (tag.m_128441_("Managers")) {
            ListTag managerList = tag.m_128437_("Managers", 8);
            managerList.forEach(manager -> net.managers.add(UUID.fromString(manager.m_7916_())));
        }
        if (tag.m_128441_("Players")) {
            ListTag playerList = tag.m_128437_("Players", 8);
            playerList.forEach(player -> net.players.add(UUID.fromString(player.m_7916_())));
        }
        net.currentTime = tag.m_128451_("currentTime");
        if (tag.m_128441_("Deleted")) {
            net.deleted = tag.m_128471_("Deleted");
        }
        return net;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128405_("Id", this.id);
        if (this.owner != null) {
            tag.m_128362_("Owner", this.owner);
        }
        if (!tag.m_128441_("OldDataTag")) {
            tag.m_128379_("OldDataTag", true);
        }
        ListTag managerListTag = new ListTag();
        for (UUID manager : this.managers) {
            managerListTag.add((Object)StringTag.m_129297_((String)manager.toString()));
        }
        tag.m_128365_("Managers", (Tag)managerListTag);
        ListTag playerListTag = new ListTag();
        for (UUID player : this.players) {
            playerListTag.add((Object)StringTag.m_129297_((String)player.toString()));
        }
        tag.m_128365_("Players", (Tag)playerListTag);
        tag.m_128365_("UnifiedStorage", (Tag)this.unifiedStorage.serializeNBT());
        tag.m_128405_("currentTime", this.currentTime);
        tag.m_128379_("Deleted", this.deleted);
        return tag;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int Id) {
        this.id = Id;
        this.m_77762_();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.addManager(owner);
        this.m_77762_();
    }

    public Set<UUID> getManagers() {
        return this.managers;
    }

    public void addManager(UUID managerId) {
        this.managers.add(managerId);
        this.addPlayer(managerId);
        this.m_77762_();
    }

    public void removeManager(UUID managerId) {
        if (managerId.equals(this.owner)) {
            return;
        }
        this.managers.remove(managerId);
        this.m_77762_();
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    public void addPlayer(UUID playerId) {
        this.players.add(playerId);
        this.m_77762_();
    }

    public void removePlayer(UUID playerId) {
        if (playerId == this.owner) {
            return;
        }
        this.players.remove(playerId);
        if (this.managers.contains(playerId)) {
            this.managers.remove(playerId);
        }
        this.m_77762_();
    }

    public boolean isOwner(Player player) {
        return player.m_20148_().equals(this.getOwner());
    }

    public boolean isOwner(UUID playerId) {
        return playerId.equals(this.getOwner());
    }

    public boolean isManager(Player player) {
        return this.managers.contains(player.m_20148_());
    }

    public boolean isManager(UUID playerId) {
        return this.managers.contains(playerId);
    }

    public void mergeOtherNet(DimensionsNet otherNet) {
        for (Map.Entry<UUID, PlayerPermissionInfo> entry : otherNet.getPlayerPermissionInfoMap(ServerLifecycleHooks.getCurrentServer()).entrySet()) {
            if (entry.getValue().level() == NetPermissionlevel.Owner || entry.getValue().level() == NetPermissionlevel.Manager) {
                this.addManager(entry.getKey());
                continue;
            }
            if (entry.getValue().level() != NetPermissionlevel.Member) continue;
            this.addPlayer(entry.getKey());
        }
        for (IStackType stack : otherNet.getUnifiedStorage().getStorage()) {
            this.unifiedStorage.insert(stack, false);
        }
        otherNet.destroySelf();
    }

    public void destroySelf() {
        this.owner = null;
        this.managers.clear();
        this.players.clear();
        this.id = -99;
        this.unifiedStorage.clearStorage();
        this.deleted = true;
    }

    public HashMap<UUID, PlayerPermissionInfo> getPlayerPermissionInfoMap(MinecraftServer dataProvider) {
        HashMap<UUID, PlayerPermissionInfo> infoMap = new HashMap<UUID, PlayerPermissionInfo>();
        for (UUID playerId : this.players) {
            if (this.isOwner(playerId)) {
                infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, dataProvider), NetPermissionlevel.Owner));
                continue;
            }
            if (this.isManager(playerId)) {
                infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, dataProvider), NetPermissionlevel.Manager));
                continue;
            }
            infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, dataProvider), NetPermissionlevel.Member));
        }
        return infoMap;
    }

    public UnifiedStorage getUnifiedStorage() {
        return this.unifiedStorage;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (this.temporary) {
            return;
        }
        --this.currentTime;
        this.m_77762_();
        if (this.currentTime <= 0) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.SHATTERED_SPACE_TIME_CRYSTALLIZATION.get(), 1);
            ItemStackType stackType = new ItemStackType(stack);
            this.unifiedStorage.insert(stackType, false);
            this.currentTime = this.holdTime;
        }
    }
}

