/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler.Chemicals;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.Chemicals.GasStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;

public class GasStackTypedHandler
implements IGasHandler {
    private StackTypedHandler handlerStorage;

    public GasStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getTanks() {
        return this.handlerStorage.getTypeIdIndexList(GasStackType.ID).map(List::size).orElse(0);
    }

    public GasStack getChemicalInTank(int tank) {
        return this.handlerStorage.getTypeIdIndexList(GasStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(obj -> (GasStack)obj.getStack()).orElse(GasStack.EMPTY);
    }

    public void setChemicalInTank(int tank, GasStack stack) {
        this.handlerStorage.getTypeIdIndexList(GasStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).ifPresent(actualIndex -> this.handlerStorage.setStackDirectly((int)actualIndex, new GasStackType(stack.copy())));
    }

    public long getTankCapacity(int tank) {
        return 64000L;
    }

    public boolean isValid(int tank, GasStack stack) {
        return true;
    }

    public GasStack insertChemical(int tank, GasStack stack, Action action) {
        if (stack.isEmpty()) {
            return GasStack.EMPTY;
        }
        return this.handlerStorage.getTypeIdIndexList(GasStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> {
            IStackType remainingStack = this.handlerStorage.insert((int)actualIndex, new GasStackType(stack.copy()), action.simulate());
            long remaining = remainingStack.getStackAmount();
            return remaining > 0L ? new GasStack(stack, remaining) : GasStack.EMPTY;
        }).orElse(stack.copy());
    }

    public GasStack extractChemical(int tank, long amount, Action action) {
        return this.handlerStorage.getTypeIdIndexList(GasStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> this.handlerStorage.extract((int)actualIndex, amount, action.simulate())).map(extracts -> ((GasStackType)extracts).copyStack()).orElse(GasStack.EMPTY);
    }

    public GasStack insertChemical(GasStack stack, Action action) {
        if (stack.isEmpty()) {
            return GasStack.EMPTY;
        }
        long remaining = this.handlerStorage.insert(new GasStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new GasStack(stack, remaining);
        }
        return GasStack.EMPTY;
    }

    public GasStack extractChemical(long amount, Action action) {
        return this.handlerStorage.getTypeIdIndexList(GasStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(stack -> stack.copy()).map(stack -> this.handlerStorage.extract((IStackType)stack, action.simulate())).map(extracts -> ((GasStackType)extracts).copyStack()).orElse(GasStack.EMPTY);
    }

    public GasStack extractChemical(GasStack stack, Action action) {
        return ((GasStackType)this.handlerStorage.extract(new GasStackType(stack.copy()), action.simulate())).copyStack();
    }

    public GasStack getEmptyStack() {
        return GasStack.EMPTY;
    }
}

