/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FluidStackType
implements IStackType<FluidStack> {
    public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"beyonddimensions", (String)"stack_type/fluid");
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    private FluidStack stack;
    private long stackSize;
    private int hashCodeCache = 0;
    private boolean NeedRecalHash = true;

    public FluidStackType() {
        this.stack = FluidStack.EMPTY;
        this.stackSize = 0L;
    }

    public FluidStackType(FluidStack stack) {
        this.stack = stack;
        this.stackSize = stack.getAmount();
    }

    public FluidStackType(FluidStack stack, long stackSize) {
        this.stack = stack;
        this.stackSize = stackSize;
    }

    @Override
    public IStackType<FluidStack> fromObject(Object key, long amount, CompoundTag dataComponentPatch) {
        if (key instanceof Fluid) {
            Fluid fluid = (Fluid)key;
            FluidStack fluidStack = dataComponentPatch != null ? new FluidStack(fluid, 1, dataComponentPatch) : new FluidStack(fluid, 1);
            return new FluidStackType(fluidStack, amount);
        }
        return null;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public IStackType<FluidStack> getEmpty() {
        return new FluidStackType();
    }

    @Override
    public FluidStack getStack() {
        if (this.stack.getRawFluid() != Fluids.f_76191_) {
            this.stack.setAmount(BDMath.clampLongToInt(this.stackSize));
        }
        return this.stack;
    }

    @Override
    public void setStack(FluidStack stack) {
        this.stack = stack.copy();
        this.stackSize = stack.getAmount();
        if (this.stack.getRawFluid() != Fluids.f_76191_) {
            this.stack.setAmount(1);
        }
        this.NeedRecalHash = true;
    }

    @Override
    public Class<FluidStack> getStackClass() {
        return FluidStack.class;
    }

    @Override
    public Class<?> getSourceClass() {
        return Fluid.class;
    }

    @Override
    public Object getSource() {
        return FluidStack.EMPTY.getFluid();
    }

    @Override
    public String getModId() {
        ResourceLocation key = ForgeRegistries.FLUIDS.getKey((Object)this.stack.getFluid());
        return key != null ? key.m_135827_() : "unknown";
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty() || this.stackSize <= 0L;
    }

    @Override
    public boolean isEmptyStack() {
        return this.stack.isEmpty();
    }

    @Override
    public FluidStack getEmptyStack() {
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack copyStack() {
        FluidStack copy = this.stack.copy();
        if (this.stack.getRawFluid() != Fluids.f_76191_) {
            copy.setAmount(BDMath.clampLongToInt(this.stackSize));
        }
        return copy;
    }

    @Override
    public FluidStack copyStackWithCount(long count) {
        FluidStack copy = this.stack.copy();
        if (this.stack.getRawFluid() != Fluids.f_76191_) {
            copy.setAmount(BDMath.clampLongToInt(count));
        }
        return copy;
    }

    @Override
    public IStackType<FluidStack> copy() {
        FluidStackType copy = new FluidStackType(this.stack.copy(), this.stackSize);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<FluidStack> copyWithCount(long count) {
        FluidStackType copy = new FluidStackType(this.stack.copy(), count);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public long getStackAmount() {
        return this.stackSize;
    }

    @Override
    public void setStackAmount(long amount) {
        this.stackSize = amount;
    }

    @Override
    public void grow(long amount) {
        this.setStackAmount(this.getStackAmount() + amount);
    }

    @Override
    public void shrink(long amount) {
        this.grow(-amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return Math.min(64000L, this.getCustomMaxStackSize());
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public FluidStack splitStack(long amount) {
        if (amount <= 0L || this.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int splitAmount = BDMath.clampLongToInt(Math.min(amount, this.stackSize));
        FluidStack split = this.stack.copy();
        split.setAmount(splitAmount);
        this.shrink(splitAmount);
        return split;
    }

    @Override
    public IStackType<FluidStack> split(long amount) {
        if (amount <= 0L || this.isEmpty()) {
            return new FluidStackType();
        }
        long splitAmount = Math.min(amount, this.stackSize);
        FluidStack split = this.stack.copy();
        this.shrink(splitAmount);
        return new FluidStackType(split, splitAmount);
    }

    @Override
    public boolean isSame(IStackType<FluidStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return this.stack.getFluid() == other.copyStackWithCount(1L).getFluid();
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<FluidStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return this.stack.isFluidEqual(other.copyStackWithCount(1L));
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.m_130085_(this.getTypeId());
        boolean hasItem = !this.stack.isEmpty();
        buf.writeBoolean(hasItem);
        if (hasItem) {
            buf.m_130103_(this.stackSize);
            FluidStack copy = new FluidStack(this.stack, 1);
            copy.writeToPacket(buf);
        }
    }

    @Override
    public IStackType<FluidStack> deserialize(FriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        boolean hasItem = buf.readBoolean();
        if (!hasItem) {
            return new FluidStackType(FluidStack.EMPTY);
        }
        long count = buf.m_130258_();
        FluidStack stack = new FluidStack(FluidStack.readFromPacket((FriendlyByteBuf)buf), 1);
        return new FluidStackType(stack, count);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", ID.toString());
        tag.m_128356_("Amount", this.getStackAmount());
        tag.m_128365_("Stack", (Tag)new FluidStack(this.stack, 1).writeToNBT(new CompoundTag()));
        return tag;
    }

    @Override
    public IStackType<FluidStack> deserializeNBT(CompoundTag nbt) {
        FluidStackType stack = new FluidStackType(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("Stack")));
        stack.setStackAmount(nbt.m_128454_("Amount"));
        return stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        IClientFluidTypeExtensions renderProperties;
        ResourceLocation fluidStill;
        Optional<TextureAtlasSprite> fluidStillSprite;
        PoseStack poseStack = gui.m_280168_();
        poseStack.m_85836_();
        Fluid fluid = this.stack.getFluid();
        if (!fluid.m_6212_(Fluids.f_76191_) && (fluidStillSprite = Optional.ofNullable(fluidStill = (renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid)).getStillTexture(this.stack)).map(f -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(f)).filter(s -> s.m_247685_() != MissingTextureAtlasSprite.m_118071_())).isPresent()) {
            int fluidColor = IClientFluidTypeExtensions.of((Fluid)this.stack.getFluid()).getTintColor();
            IngredientRenderer.drawTiledSprite(gui, 16, 16, fluidColor, 16L, fluidStillSprite.get(), x, y);
        }
        poseStack.m_85849_();
        String countText = this.getCountText(this.stackSize);
        float scale = 0.666f;
        PoseStack poseStackText = gui.m_280168_();
        poseStackText.m_85836_();
        poseStackText.m_252880_(0.0f, 0.0f, 200.0f);
        poseStackText.m_85841_(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.m_91087_().f_91062_.m_92895_(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!this.stack.isEmpty()) {
            gui.m_280488_(Minecraft.m_91087_().f_91062_, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.m_85849_();
    }

    @Override
    public String getCountText(long count) {
        if (count < 0L) {
            return "";
        }
        return StringFormat.formatBucket(count);
    }

    @Override
    public Component getDisplayName() {
        return this.stack.getDisplayName();
    }

    @Override
    public List<Component> getTooltipLines(@Nullable Player player, TooltipFlag tooltipFlag) {
        if (this.stack.isEmpty()) {
            return List.of(Component.m_237119_());
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        Fluid fluid = this.stack.getFluid();
        Component displayName = this.getDisplayName();
        tooltips.add(displayName);
        ResourceLocation resourceLocation = BuiltInRegistries.f_257020_.m_7981_((Object)fluid);
        if (resourceLocation != null) {
            Optional container;
            if (tooltipFlag.m_7050_()) {
                MutableComponent advancedId = Component.m_237113_((String)resourceLocation.toString()).m_130940_(ChatFormatting.DARK_GRAY);
                tooltips.add((Component)advancedId);
            }
            MutableComponent modName = (container = ModList.get().getModContainerById(resourceLocation.m_135827_())).isPresent() ? Component.m_237113_((String)((ModContainer)container.get()).getModInfo().getDisplayName()).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC) : ((container = ModList.get().getModContainerById(resourceLocation.m_135827_().replace('_', '-'))).isPresent() ? Component.m_237113_((String)((ModContainer)container.get()).getModInfo().getDisplayName()).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC) : Component.m_237113_((String)WordUtils.capitalizeFully((String)resourceLocation.m_135827_().replace('_', ' '))).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC));
            tooltips.add((Component)modName);
        }
        tooltips.add((Component)Component.m_237110_((String)"istack.beyonddimensions.storage_num.fluid", (Object[])new Object[]{this.getStackAmount()}));
        return tooltips;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage() {
        return Optional.empty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics gui, Font font, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        gui.renderTooltip(minecraft.f_91062_, this.getTooltipLines((Player)minecraft.f_91074_, (TooltipFlag)(minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)), this.getTooltipImage(), ItemStack.f_41583_, mouseX, mouseY);
    }

    public boolean equals(Object other) {
        if (other instanceof FluidStackType) {
            FluidStackType otherStack = (FluidStackType)other;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        if (this.NeedRecalHash) {
            this.hashCodeCache = this.stack.hashCode();
            this.NeedRecalHash = false;
        }
        return this.hashCodeCache;
    }
}

