/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.EnergyUnifiedStorageHandler;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class NetEnergyPathwayBlockEntity
extends NetedBlockEntity {
    public final int transHold = 20;
    public int transTime = 0;
    public boolean popMode = false;
    private final Direction[] directions = Direction.values();
    private DimensionsNet net = null;

    public NetEnergyPathwayBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_ENERGY_PATHWAY_BLOCK_ENTITY.get(), pos, blockState);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        DimensionsNet net;
        if (cap == ForgeCapabilities.ENERGY && this.getNetId() >= 0 && (net = this.getNet()) != null) {
            return LazyOptional.of(() -> new EnergyUnifiedStorageHandler(net.getUnifiedStorage())).cast();
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, NetEnergyPathwayBlockEntity blockEntity) {
        if (level.m_5776_()) {
            return;
        }
        if (blockEntity.getNetId() != -1) {
            ++blockEntity.transTime;
            if (blockEntity.transTime >= blockEntity.transHold) {
                blockEntity.transTime = 0;
            }
        }
        if (blockEntity.popMode && blockEntity.getNetId() >= 0) {
            blockEntity.popEnergy();
        }
    }

    private void popEnergy() {
        if (this.net == null) {
            DimensionsNet net = this.getNet();
            if (net != null) {
                this.net = net;
            } else {
                return;
            }
        }
        for (Direction dir : this.directions) {
            LazyOptional otherStorageOptional;
            BlockPos targetPos = this.m_58899_().m_121945_(dir);
            BlockEntity neighbor = this.f_58857_.m_7702_(targetPos);
            if (neighbor == null || neighbor instanceof NetedBlockEntity || !(otherStorageOptional = neighbor.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_())).isPresent()) continue;
            IEnergyStorage otherStorage = (IEnergyStorage)otherStorageOptional.resolve().get();
            int maxExtract = (int)Math.min(this.net.getUnifiedStorage().getEnergyStored(), Integer.MAX_VALUE);
            int receive = otherStorage.receiveEnergy(maxExtract, false);
            this.net.getUnifiedStorage().extract(new EnergyStackType(receive), false);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.net = null;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.popMode = tag.m_128471_("popMode");
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("popMode", this.popMode);
    }
}

