/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class NetedBlockEntity
extends BlockEntity {
    protected int netId = -1;

    public NetedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public int getNetId() {
        return this.netId;
    }

    public void setNetId(int id) {
        this.netId = id;
        this.m_6596_();
    }

    public void clearNetId() {
        this.netId = -1;
        this.m_6596_();
    }

    public void setNetIdFromPlayer(ServerPlayer player) {
        DimensionsNet net = DimensionsNet.getNetFromPlayer((Player)player);
        if (net != null) {
            this.netId = net.getId();
            this.m_6596_();
        }
    }

    public void setNetIdFromPlayerOrClean(ServerPlayer player) {
        DimensionsNet net = DimensionsNet.getNetFromPlayer((Player)player);
        if (net != null) {
            this.netId = net.getId();
            this.m_6596_();
        } else {
            this.netId = -1;
            this.m_6596_();
        }
    }

    public DimensionsNet getNet() {
        if (this.netId >= 0) {
            if (this.m_58904_() instanceof ServerLevel) {
                return DimensionsNet.getNetFromId(this.netId, this.m_58904_().m_7654_());
            }
        } else {
            return null;
        }
        return null;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.netId = tag.m_128451_("netId");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("netId", this.netId);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public @Nullable Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

