/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.EMI.Recipe;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Network.Packet.toServer.RecipeFillC2SPacket;
import com.wintercogs.beyonddimensions.Registry.PacketRegister;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class NetRecipeHandler<T extends DimensionsCraftMenu>
implements StandardRecipeHandler<T> {
    public List<Slot> getInputSources(T handler) {
        ArrayList<Slot> inputSlots = new ArrayList<Slot>();
        for (Slot slot : ((DimensionsCraftMenu)((Object)handler)).f_38839_) {
            if (slot instanceof ResultSlot || slot instanceof StoredStackSlot) continue;
            inputSlots.add(slot);
        }
        return inputSlots;
    }

    public List<Slot> getCraftingSlots(T handler) {
        ArrayList<Slot> craftingSlots = new ArrayList<Slot>();
        for (int i = ((DimensionsCraftMenu)((Object)handler)).craftSlotStartIndex; i <= ((DimensionsCraftMenu)((Object)handler)).craftSlotEndIndex; ++i) {
            craftingSlots.add((Slot)((DimensionsCraftMenu)((Object)handler)).f_38839_.get(i));
        }
        return craftingSlots;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree();
    }

    public EmiPlayerInventory getInventory(AbstractContainerScreen<T> screen) {
        List stacks = this.getInputSources((T)((Object)((DimensionsCraftMenu)screen.m_6262_()))).stream().map(Slot::m_7993_).map(EmiStack::of).collect(Collectors.toCollection(ArrayList::new));
        if (((DimensionsCraftMenu)screen.m_6262_()).storage.getStorage() != null) {
            for (IStackType stackType : ((DimensionsCraftMenu)screen.m_6262_()).storage.getStorage()) {
                ItemStackType itemStackType;
                if (!(stackType instanceof ItemStackType) || (itemStackType = (ItemStackType)stackType).isEmpty()) continue;
                stacks.add(EmiStack.of((ItemStack)itemStackType.getStack()));
            }
        }
        return new EmiPlayerInventory(stacks);
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        Minecraft.m_91087_().m_91152_((Screen)context.getScreen());
        List inputs = recipe.getInputs();
        ArrayList<ItemStack> inputElements = new ArrayList<ItemStack>();
        DimensionsCraftMenu menu = (DimensionsCraftMenu)context.getScreen().m_6262_();
        List<Slot> craftingSlots = this.getInputSources((T)((Object)menu));
        List<IStackType> storageSlots = menu.storage.getStorage();
        ArrayList<ItemStack> availableItems = new ArrayList<ItemStack>();
        for (Slot slot : craftingSlots) {
            if (!slot.m_6657_()) continue;
            availableItems.add(slot.m_7993_());
        }
        for (IStackType stackType : storageSlots) {
            ItemStackType itemStackType;
            ItemStack stack;
            if (!(stackType instanceof ItemStackType) || (stack = (itemStackType = (ItemStackType)stackType).getStack()).m_41619_()) continue;
            availableItems.add(stack);
        }
        for (ItemStack itemStack : menu.player.m_150109_().f_35974_) {
            if (itemStack.m_41619_()) continue;
            availableItems.add(itemStack);
        }
        block3: for (EmiIngredient ingredient : inputs) {
            if (ingredient.isEmpty()) {
                inputElements.add(ItemStack.f_41583_);
                continue;
            }
            ArrayList<ItemStack> matching = new ArrayList<ItemStack>();
            for (ItemStack stack : availableItems) {
                if (stack.m_41619_() || !ingredient.getEmiStacks().stream().anyMatch(emiStack -> emiStack.getItemStack().m_41720_() == stack.m_41720_())) continue;
                matching.add(stack.m_41777_());
            }
            int required = (int)ingredient.getAmount();
            int available = matching.stream().mapToInt(ItemStack::m_41613_).sum();
            if (available >= required) {
                ItemStack merged = matching.isEmpty() ? ItemStack.f_41583_ : ((ItemStack)matching.get(0)).m_255036_(required);
                inputElements.add(merged);
                int remaining = required;
                for (ItemStack stack : matching) {
                    int deduct = Math.min(remaining, stack.m_41613_());
                    stack.m_41774_(deduct);
                    if ((remaining -= deduct) > 0) continue;
                    continue block3;
                }
                continue;
            }
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"beyonddimensions.message.insufficient_materials"), true);
            return true;
        }
        PacketRegister.INSTANCE.sendToServer((Object)new RecipeFillC2SPacket(inputElements));
        return true;
    }
}

