/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.NetControlAction;
import com.wintercogs.beyonddimensions.Api.DataBase.PlayerPermissionInfo;
import com.wintercogs.beyonddimensions.Menu.BDOrderedContainerMenu;
import com.wintercogs.beyonddimensions.Network.Packet.toClient.PlayerPermissionInfoPacket;
import com.wintercogs.beyonddimensions.Registry.PacketRegister;
import com.wintercogs.beyonddimensions.Registry.UIRegister;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class NetControlMenu
extends BDOrderedContainerMenu {
    private DimensionsNet net = new DimensionsNet(true);
    public HashMap<UUID, PlayerPermissionInfo> playerInfo = new HashMap();

    public NetControlMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory);
    }

    public NetControlMenu(int containerId, Inventory playerInventory) {
        super(UIRegister.Net_Control_Menu.get(), containerId, playerInventory, null);
        if (!this.player.m_9236_().m_5776_()) {
            this.net = DimensionsNet.getNetFromPlayer(this.player);
            this.playerInfo = this.net.getPlayerPermissionInfoMap(this.player.m_20194_());
        }
    }

    public void handlePlayerAction(UUID receiver, NetControlAction action) {
        if (action == NetControlAction.SetOwner) {
            if (this.net.isOwner(this.player) && !this.player.m_20148_().equals(receiver)) {
                this.net.setOwner(receiver);
            }
        } else if (action == NetControlAction.SetManager) {
            if (this.net.isOwner(this.player) && !this.net.isManager(receiver)) {
                this.net.addManager(receiver);
            }
        } else if (action == NetControlAction.RemoveManager) {
            if (this.net.isOwner(this.player) && this.net.isManager(receiver) && !this.net.isOwner(receiver)) {
                this.net.removeManager(receiver);
            }
        } else if (action == NetControlAction.RemovePlayer) {
            if (this.net.isManager(this.player) && !this.net.isManager(receiver)) {
                this.net.removePlayer(receiver);
            } else if (this.player.m_20148_().equals(receiver) && !this.net.isOwner(receiver)) {
                this.net.removePlayer(receiver);
            } else if (this.net.isOwner(this.player) && !this.player.m_20148_().equals(receiver)) {
                this.net.removePlayer(receiver);
            }
        }
    }

    @Override
    protected void updateChange() {
        if (!this.net.getPlayerPermissionInfoMap(this.player.m_20194_()).equals(this.playerInfo)) {
            this.playerInfo = this.net.getPlayerPermissionInfoMap(this.player.m_20194_());
            this.sendPlayerInfo();
        }
    }

    @Override
    protected void initUpdate() {
        this.sendPlayerInfo();
    }

    public void sendPlayerInfo() {
        PacketRegister.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new PlayerPermissionInfoPacket(this.playerInfo));
    }

    public void loadPlayerInfo(HashMap<UUID, PlayerPermissionInfo> playerInfo) {
        this.playerInfo = playerInfo;
    }

    @Override
    public boolean m_6875_(Player player) {
        return true;
    }
}

