/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.ClientOrServer;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Menu.DimensionsNetMenu;
import com.wintercogs.beyonddimensions.Menu.NetInterfaceBaseMenu;
import com.wintercogs.beyonddimensions.Registry.PacketRegister;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record CallSeverClickPacket(int slotIndex, IStackType clickItem, int button, boolean shiftDown) {
    private void handleServer(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof DimensionsNetMenu) {
            DimensionsNetMenu menu = (DimensionsNetMenu)abstractContainerMenu;
            menu.customClickHandler(this.slotIndex(), this.clickItem(), this.button(), this.shiftDown());
            menu.m_38946_();
            PacketRegister.INSTANCE.send(PacketDistributor.PLAYER.with(() -> CallSeverClickPacket.lambda$handleServer$0((Player)player)), (Object)new CallSeverClickPacket(1, new ItemStackType(ItemStack.f_41583_), 1, false));
            return;
        }
        abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof NetInterfaceBaseMenu) {
            NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)abstractContainerMenu;
            menu.customClickHandler(this.slotIndex(), this.clickItem(), this.button(), this.shiftDown());
            menu.m_38946_();
            PacketRegister.INSTANCE.send(PacketDistributor.PLAYER.with(() -> CallSeverClickPacket.lambda$handleServer$1((Player)player)), (Object)new CallSeverClickPacket(1, new ItemStackType(ItemStack.f_41583_), 1, false));
            return;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient(NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof DimensionsNetMenu) {
            DimensionsNetMenu menu = (DimensionsNetMenu)abstractContainerMenu;
            menu.isHanding = false;
            return;
        }
        abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof NetInterfaceBaseMenu) {
            NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)abstractContainerMenu;
            menu.isHanding = false;
        }
    }

    public static void handle(CallSeverClickPacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            NetworkDirection direction = context.getDirection();
            if (direction == NetworkDirection.PLAY_TO_CLIENT) {
                context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> packet.handleClient(context)));
                context.setPacketHandled(true);
            } else if (direction == NetworkDirection.PLAY_TO_SERVER) {
                context.enqueueWork(() -> packet.handleServer(context));
                context.setPacketHandled(true);
            }
        }
    }

    public static void encode(CallSeverClickPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.slotIndex());
        IStackType stackType = packet.clickItem();
        stackType.serialize(buf);
        buf.writeInt(packet.button());
        buf.writeBoolean(packet.shiftDown());
    }

    public static CallSeverClickPacket decode(FriendlyByteBuf buf) {
        int slotIndex = buf.readInt();
        IStackType clickItem = IStackType.deserializeCommon(buf);
        int button = buf.readInt();
        boolean shiftDown = buf.readBoolean();
        return new CallSeverClickPacket(slotIndex, clickItem, button, shiftDown);
    }

    private static /* synthetic */ ServerPlayer lambda$handleServer$1(Player player) {
        return (ServerPlayer)player;
    }

    private static /* synthetic */ ServerPlayer lambda$handleServer$0(Player player) {
        return (ServerPlayer)player;
    }
}

