/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.toClient;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Menu.NetInterfaceBaseMenu;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record SyncFlagPacket(List<IStackType> flags, List<Integer> targetIndex) {
    @OnlyIn(value=Dist.CLIENT)
    private void handle(NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof NetInterfaceBaseMenu) {
            NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)abstractContainerMenu;
            StackTypedHandler clientStorage = menu.flagStorage;
            int i = 0;
            for (IStackType remoteStack : this.flags()) {
                clientStorage.setStackDirectly(this.targetIndex().get(i), remoteStack.copyWithCount(1L));
                ++i;
            }
            menu.updateViewerStorage();
        }
    }

    public static void handle(SyncFlagPacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> packet.handle(context)));
            context.setPacketHandled(true);
        }
    }

    public static void encode(SyncFlagPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.flags().size());
        for (IStackType flag : packet.flags()) {
            flag.serialize(buf);
        }
        buf.writeInt(packet.targetIndex().size());
        Iterator<Object> iterator = packet.targetIndex().iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            buf.writeInt(index);
        }
    }

    public static SyncFlagPacket decode(FriendlyByteBuf buf) {
        int flagsSize = buf.readInt();
        ArrayList<IStackType> flags = new ArrayList<IStackType>(flagsSize);
        for (int i = 0; i < flagsSize; ++i) {
            flags.add(IStackType.deserializeCommon(buf));
        }
        int indicesSize = buf.readInt();
        ArrayList<Integer> targetIndex = new ArrayList<Integer>(indicesSize);
        for (int i = 0; i < indicesSize; ++i) {
            targetIndex.add(buf.readInt());
        }
        return new SyncFlagPacket(flags, targetIndex);
    }
}

