/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.toClient;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.DimensionsNetMenu;
import com.wintercogs.beyonddimensions.Menu.NetInterfaceBaseMenu;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record SyncStoragePacket(List<IStackType> stacks, List<Long> changedCounts, List<Integer> targetIndex) {
    @OnlyIn(value=Dist.CLIENT)
    private void handle(NetworkEvent.Context context) {
        int i;
        Object clientStorage;
        BDBaseMenu menu;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof DimensionsNetMenu) {
            menu = (DimensionsNetMenu)abstractContainerMenu;
            clientStorage = ((DimensionsNetMenu)menu).storage;
            i = 0;
            for (IStackType remoteStack : this.stacks()) {
                if (clientStorage.hasStackType(remoteStack)) {
                    if (this.changedCounts().get(i) > 0L) {
                        clientStorage.insert(remoteStack.copyWithCount(this.changedCounts().get(i)), false);
                    } else {
                        clientStorage.extract(remoteStack.copyWithCount(-this.changedCounts().get(i).longValue()), false);
                    }
                } else if (this.changedCounts().get(i) > 0L) {
                    clientStorage.insert(remoteStack.copyWithCount(this.changedCounts().get(i)), false);
                }
                ++i;
            }
            if (!((DimensionsNetMenu)menu).hasShiftDown) {
                ((DimensionsNetMenu)menu).updateViewerStorage();
            } else {
                ((DimensionsNetMenu)menu).updateOnlyCountAndNewViewer();
            }
        }
        if ((clientStorage = player.f_36096_) instanceof NetInterfaceBaseMenu) {
            menu = (NetInterfaceBaseMenu)((Object)clientStorage);
            clientStorage = ((NetInterfaceBaseMenu)menu).storage;
            i = 0;
            for (IStackType remoteStack : this.stacks()) {
                if (this.changedCounts().get(i) > 0L) {
                    clientStorage.insert(this.targetIndex().get(i), remoteStack.copyWithCount(this.changedCounts().get(i)), false);
                } else {
                    clientStorage.extract(this.targetIndex().get(i), -this.changedCounts().get(i).longValue(), false);
                }
                ++i;
            }
            ((NetInterfaceBaseMenu)menu).updateViewerStorage();
        }
    }

    public static void handle(SyncStoragePacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> packet.handle(context)));
            context.setPacketHandled(true);
        }
    }

    public static void encode(SyncStoragePacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.stacks().size());
        for (IStackType stack : packet.stacks()) {
            stack.serialize(buf);
        }
        buf.writeInt(packet.changedCounts().size());
        Iterator<Object> iterator = packet.changedCounts().iterator();
        while (iterator.hasNext()) {
            long count = (Long)iterator.next();
            buf.writeLong(count);
        }
        buf.writeInt(packet.targetIndex().size());
        iterator = packet.targetIndex().iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            buf.writeInt(index);
        }
    }

    public static SyncStoragePacket decode(FriendlyByteBuf buf) {
        int stacksSize = buf.readInt();
        ArrayList<IStackType> stacks = new ArrayList<IStackType>(stacksSize);
        for (int i = 0; i < stacksSize; ++i) {
            stacks.add(IStackType.deserializeCommon(buf));
        }
        int countsSize = buf.readInt();
        ArrayList<Long> changedCounts = new ArrayList<Long>(countsSize);
        for (int i = 0; i < countsSize; ++i) {
            changedCounts.add(buf.readLong());
        }
        int indicesSize = buf.readInt();
        ArrayList<Integer> targetIndex = new ArrayList<Integer>(indicesSize);
        for (int i = 0; i < indicesSize; ++i) {
            targetIndex.add(buf.readInt());
        }
        return new SyncStoragePacket(stacks, changedCounts, targetIndex);
    }
}

