/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.DataBase.ButtonName;
import com.wintercogs.beyonddimensions.DataBase.ButtonState;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.GUI.BDBaseGUI;
import com.wintercogs.beyonddimensions.GUI.Widget.Button.ReverseButton;
import com.wintercogs.beyonddimensions.GUI.Widget.Button.SortMethodButton;
import com.wintercogs.beyonddimensions.GUI.Widget.Scroller.BigScroller;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class DimensionsCraftGUI
extends BDBaseGUI<DimensionsCraftMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.parse((String)"beyonddimensions:textures/gui/dimensions_net_craft.png");
    private EditBox searchField;
    private HashMap<ButtonName, ButtonState> buttonStateMap = new HashMap();
    private HashMap<ButtonName, ButtonState> lastButtonStateMap = new HashMap();
    private String lastSearchText = "";
    private ReverseButton reverseButton;
    private SortMethodButton sortButton;
    private BigScroller scroller;

    public DimensionsCraftGUI(DimensionsCraftMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.imageWidth = 194;
        this.imageHeight = 256;
    }

    protected void init() {
        this.leftPos = (this.width - 176) / 2;
        this.topPos = (this.height - 256) / 2;
        this.sortButton = new SortMethodButton(this.leftPos + 40 + 108, this.topPos + 138 - 16 - 5, button -> {
            this.sortButton.toggleState();
            this.buttonStateMap.put(this.sortButton.getName(), this.sortButton.currentState);
        });
        this.addRenderableWidget((GuiEventListener)this.sortButton);
        this.reverseButton = new ReverseButton(this.leftPos + 40 + 108, this.topPos + 138 + 5, button -> {
            this.reverseButton.toggleState();
            this.buttonStateMap.put(this.reverseButton.getName(), this.reverseButton.currentState);
        });
        this.addRenderableWidget((GuiEventListener)this.reverseButton);
        this.buttonStateMap.put(this.sortButton.getName(), this.sortButton.currentState);
        this.buttonStateMap.put(this.reverseButton.getName(), this.reverseButton.currentState);
        Font font = this.getFont();
        Objects.requireNonNull(this.getFont());
        this.searchField = new EditBox(font, this.leftPos + 20 + 26 + 10, this.topPos + 5, 89, 9 + 4, (Component)Component.translatable((String)"wintercogs.beyonddimensions.dimensionsguisearch"));
        this.searchField.setSuggestion(Component.translatable((String)"wintercogs.beyonddimensions.dimensionsguisearch").getString());
        this.searchField.setMaxLength(100);
        this.searchField.setBordered(true);
        this.searchField.setVisible(true);
        this.searchField.setTextColor(0xFFFFFF);
        this.addRenderableWidget((GuiEventListener)this.searchField);
        this.scroller = new BigScroller(this.leftPos + 174, this.topPos + 20, 95, 0, ((DimensionsCraftMenu)this.menu).maxLineData);
        this.addRenderableWidget((GuiEventListener)this.scroller);
        this.lastButtonStateMap = new HashMap<ButtonName, ButtonState>(this.buttonStateMap);
        this.lastSearchText = this.searchField.getValue();
    }

    protected void containerTick() {
        if (!this.lastButtonStateMap.equals(this.buttonStateMap) || !Objects.equals(this.lastSearchText, this.searchField.getValue())) {
            if (!this.searchField.getValue().equals("")) {
                this.searchField.setSuggestion(null);
            } else {
                this.searchField.setSuggestion(Component.translatable((String)"wintercogs.beyonddimensions.dimensionsguisearch").getString());
            }
            ((DimensionsCraftMenu)this.menu).loadSearchText(this.searchField.getValue());
            ((DimensionsCraftMenu)this.menu).loadButtonState(this.buttonStateMap);
            ((DimensionsCraftMenu)this.menu).buildIndexList(new ArrayList<IStackType>(((DimensionsCraftMenu)this.menu).viewerStorage.getStorage()));
            this.lastButtonStateMap = new HashMap<ButtonName, ButtonState>(this.buttonStateMap);
            this.lastSearchText = this.searchField.getValue();
        }
        this.scroller.updateScrollPosition(((DimensionsCraftMenu)this.menu).lineData, ((DimensionsCraftMenu)this.menu).maxLineData);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        guiGraphics.blit(GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.searchField.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.reverseButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.scroller.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY + 2, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, 166, 0x404040, false);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        if (scrollY > 0.0) {
            --((DimensionsCraftMenu)this.menu).lineData;
        } else if (scrollY < 0.0) {
            ++((DimensionsCraftMenu)this.menu).lineData;
        }
        ((DimensionsCraftMenu)this.menu).buildIndexList(new ArrayList<IStackType>(((DimensionsCraftMenu)this.menu).viewerStorage.getStorage()));
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        int scrollY = this.scroller.customDragAction(mouseX, mouseY, button, dragX, dragY);
        if (scrollY > 0) {
            --((DimensionsCraftMenu)this.menu).lineData;
        } else if (scrollY < 0) {
            ++((DimensionsCraftMenu)this.menu).lineData;
        }
        ((DimensionsCraftMenu)this.menu).buildIndexList(new ArrayList<IStackType>(((DimensionsCraftMenu)this.menu).viewerStorage.getStorage()));
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean flag;
        super.mouseClicked(mouseX, mouseY, button);
        boolean bl = flag = this.searchField.active && this.searchField.visible && mouseX >= (double)this.searchField.getX() && mouseY >= (double)this.searchField.getY() && mouseX < (double)(this.searchField.getX() + this.searchField.getWidth()) && mouseY < (double)(this.searchField.getY() + this.searchField.getHeight());
        if (!flag) {
            if (this.getFocused() != null && this.getFocused() == this.searchField) {
                this.searchField.setFocused(false);
                this.setFocused(null);
            }
        } else if (button == 1) {
            this.searchField.setValue("");
        }
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.searchField.isFocused() && (mouseKey.getValue() >= 48 && mouseKey.getValue() <= 57 || mouseKey.getValue() >= 65 && mouseKey.getValue() <= 90 || mouseKey.getValue() >= 320 && mouseKey.getValue() <= 329 || mouseKey.getValue() == 32)) {
            return true;
        }
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public Font getFont() {
        return this.font;
    }
}

