/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI.SharedWidget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.DataBase.ButtonName;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class IconButton
extends Button {
    protected ButtonName name;
    protected ResourceLocation icon;
    protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/slot_button"), ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/slot_button_disabled"), ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/slot_button_hovered"));

    protected IconButton(int x, int y, int width, int height, ResourceLocation icon, ButtonName name, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.icon = icon;
        this.name = name;
    }

    public void renderWidget(GuiGraphics st, int mouseX, int mouseY, float pt) {
        if (this.visible) {
            int x = this.getX();
            int y = this.getY();
            st.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.isHovered = mouseX >= x && mouseY >= y && mouseX < x + this.width && mouseY < y + this.height;
            st.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
            this.drawIcon(st, mouseX, mouseY, pt);
            st.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void onRelease(double mouseX, double mouseY) {
        this.setFocused(false);
    }

    protected void drawIcon(GuiGraphics st, int mouseX, int mouseY, float pt) {
        st.blitSprite(this.getIcon(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public void setIcon(ResourceLocation icon) {
        this.icon = icon;
    }

    public ButtonName getName() {
        return this.name;
    }
}

