/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import java.util.Objects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class BDBaseMenu
extends AbstractContainerMenu {
    public final IStackTypedHandler storage;
    protected final Player player;
    protected int inventoryStartIndex = -1;
    protected int inventoryEndIndex = -1;
    private boolean init = false;
    public boolean isHanding = false;

    protected BDBaseMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory, @Nullable IStackTypedHandler storage) {
        super(menuType, containerId);
        this.player = playerInventory.player;
        this.storage = storage;
    }

    public void broadcastChanges() {
        for (int i = 0; i < this.slots.size(); ++i) {
            Slot slot = (Slot)this.slots.get(i);
            if (slot instanceof StoredStackSlot) continue;
            ItemStack itemstack = slot.getItem();
            Objects.requireNonNull(itemstack);
            Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).copy());
            this.triggerSlotListeners(i, itemstack, (java.util.function.Supplier)supplier);
            this.synchronizeSlotToRemote(i, itemstack, (java.util.function.Supplier)supplier);
        }
        this.synchronizeCarriedToRemote();
        for (int j = 0; j < this.dataSlots.size(); ++j) {
            DataSlot dataslot = (DataSlot)this.dataSlots.get(j);
            int k = dataslot.get();
            if (dataslot.checkAndClearUpdateFlag()) {
                this.updateDataSlotListeners(j, k);
            }
            this.synchronizeDataSlotToRemote(j, k);
        }
        if (!this.init) {
            this.initUpdate();
            this.init = true;
        }
        this.updateChange();
    }

    protected abstract void updateChange();

    protected abstract void initUpdate();

    public void customClickHandler(int slotIndex, IStackType clickedStack, int button, boolean shiftDown) {
        StoredStackSlot sSlot;
        Object object;
        if (this.storage == null) {
            return;
        }
        if (this.inventoryStartIndex < 0 || this.inventoryEndIndex < 0) {
            BeyondDimensions.LOGGER.info("\u8b66\u544a:\u80cc\u5305\u7d22\u5f15\u8bbe\u7f6e\u9519\u8bef\uff01\uff01\uff01");
        }
        if ((object = this.slots.get(slotIndex)) instanceof StoredStackSlot && (sSlot = (StoredStackSlot)((Object)object)).isFake()) {
            this.FakeClickHandle(slotIndex, clickedStack, button, this.player, this.storage);
            return;
        }
        if (shiftDown) {
            this.quickMoveHandle(this.player, slotIndex, clickedStack, this.storage);
        } else {
            this.clickHandle(slotIndex, clickedStack, button, this.player, this.storage);
        }
    }

    protected void FakeClickHandle(int slotIndex, IStackType clickStack, int button, Player player, IStackTypedHandler storage) {
    }

    protected abstract ItemStack quickMoveHandle(Player var1, int var2, IStackType var3, IStackTypedHandler var4);

    protected abstract void clickHandle(int var1, IStackType var2, int var3, Player var4, IStackTypedHandler var5);

    public void broadcastFullState() {
        super.broadcastFullState();
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        return ItemStack.EMPTY;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        while (!stack.isEmpty() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
            if (this.slots.get(i) instanceof StoredStackSlot) {
                this.storage.insert(StackCreater.Create(ItemStackType.ID, stack.copy(), stack.getCount()), false);
                flag = true;
                break;
            }
            Slot slot = (Slot)this.slots.get(i);
            ItemStack itemstack = slot.getItem();
            if (!itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack)) {
                int k;
                int j = itemstack.getCount() + stack.getCount();
                if (j <= (k = slot.getMaxStackSize(itemstack))) {
                    stack.setCount(0);
                    itemstack.setCount(j);
                    slot.setChanged();
                    flag = true;
                } else if (itemstack.getCount() < k) {
                    stack.shrink(k - itemstack.getCount());
                    itemstack.setCount(k);
                    slot.setChanged();
                    flag = true;
                }
            }
            if (itemstack.isEmpty() && slot.mayPlace(stack)) {
                int l = slot.getMaxStackSize(stack);
                slot.setByPlayer(stack.split(Math.min(stack.getCount(), l)));
                slot.setChanged();
                flag = true;
            }
            if (reverseDirection) {
                --i;
                continue;
            }
            ++i;
        }
        return flag;
    }

    protected int checkCanMoveStackCount(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        int flag = 0;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        while (!stack.isEmpty() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
            if (this.slots.get(i) instanceof StoredStackSlot) {
                flag = stack.getMaxStackSize();
                break;
            }
            Slot slot = (Slot)this.slots.get(i);
            ItemStack itemstack = slot.getItem();
            if (!itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack)) {
                int k = slot.getMaxStackSize(itemstack);
                int maxCanPut = k - itemstack.getCount();
                flag += maxCanPut;
            }
            if (itemstack.isEmpty() && slot.mayPlace(stack)) {
                int l = slot.getMaxStackSize(stack);
                flag += l;
            }
            if (reverseDirection) {
                --i;
                continue;
            }
            ++i;
        }
        return flag;
    }

    public abstract boolean stillValid(Player var1);

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        if (!(slot instanceof StoredStackSlot)) {
            return super.canTakeItemForPickAll(stack, slot);
        }
        return false;
    }
}

