/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.Api.DataBase.LongType.EnergyType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.LongStackType;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;

public class EnergyStackType
extends LongStackType<EnergyType> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"beyonddimensions", (String)"stack_type/energy");
    public static final EnergyStackType EMPTY = new EnergyStackType();

    public EnergyStackType() {
        this.stack = new EnergyType(0L);
    }

    public EnergyStackType(EnergyType stack) {
        this.stack = stack;
    }

    public EnergyStackType(long stackSize) {
        this.stack = new EnergyType(stackSize);
    }

    @Override
    public ResourceLocation getTypeID() {
        return ID;
    }

    @Override
    public IStackType<EnergyType> fromObject(Object key, long amount, DataComponentPatch dataComponentPatch) {
        if (key instanceof EnergyType) {
            return new EnergyStackType(amount);
        }
        return null;
    }

    @Override
    public IStackType<EnergyType> getEmpty() {
        return new EnergyStackType();
    }

    @Override
    public Object getSource() {
        return new EnergyType(0L);
    }

    @Override
    public EnergyType getEmptyStack() {
        return new EnergyType(0L);
    }

    @Override
    public IStackType<EnergyType> copy() {
        EnergyStackType copy = new EnergyStackType(((EnergyType)this.stack).getStackCount());
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<EnergyType> copyWithCount(long count) {
        EnergyStackType copy = new EnergyStackType(count);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<EnergyType> split(long amount) {
        if (amount <= 0L) {
            return new EnergyStackType();
        }
        long splitAmount = Math.min(amount, ((EnergyType)this.stack).getStackCount());
        ((EnergyType)this.stack).shrink(splitAmount);
        return new EnergyStackType(splitAmount);
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.getTypeId());
        buf.writeVarLong(((EnergyType)this.stack).getStackCount());
    }

    @Override
    public IStackType<EnergyType> deserialize(RegistryFriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        long count = buf.readVarLong();
        return new EnergyStackType(count);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider levelRegistryAccess) {
        CompoundTag tag = new CompoundTag();
        tag.putString("Type", ID.toString());
        tag.putLong("Amount", this.getStackAmount());
        return tag;
    }

    @Override
    public IStackType<EnergyType> deserializeNBT(CompoundTag nbt, HolderLookup.Provider levelRegistryAccess) {
        return new EnergyStackType(nbt.getLong("Amount"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        IClientFluidTypeExtensions renderProperties;
        ResourceLocation fluidStill;
        Optional<TextureAtlasSprite> fluidStillSprite;
        if (((EnergyType)this.stack).isEmpty()) {
            return;
        }
        PoseStack poseStack = gui.pose();
        poseStack.pushPose();
        FlowingFluid fluid = Fluids.WATER;
        if (!fluid.isSame(Fluids.EMPTY) && (fluidStillSprite = Optional.ofNullable(fluidStill = (renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid)).getStillTexture()).map(f -> (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(f)).filter(s -> s.atlasLocation() != MissingTextureAtlasSprite.getLocation())).isPresent()) {
            int fluidColor = 5304718;
            IngredientRenderer.drawTiledSprite(gui, 16, 16, fluidColor, 16L, fluidStillSprite.get(), x, y);
        }
        poseStack.popPose();
        String countText = this.getCountText(this.getStackAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.pose();
        poseStackText.pushPose();
        poseStackText.translate(0.0f, 0.0f, 200.0f);
        poseStackText.scale(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.getInstance().font.width(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!((EnergyType)this.stack).isEmpty()) {
            gui.drawString(Minecraft.getInstance().font, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.popPose();
    }
}

