/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientTooltipFlag;

public class ItemStackType
implements IStackType<ItemStack> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"beyonddimensions", (String)"stack_type/item");
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    private ItemStack stack;
    private long stackSize;
    private int hashCodeCache = 0;
    private boolean NeedRecalHash = true;

    public ItemStackType() {
        this.stack = ItemStack.EMPTY;
        this.stackSize = 0L;
    }

    public ItemStackType(ItemStack stack) {
        this.stack = stack;
        this.stackSize = stack.getCount();
    }

    public ItemStackType(ItemStack stack, long stackSize) {
        this.stack = stack;
        this.stackSize = stackSize;
    }

    @Override
    public IStackType<ItemStack> fromObject(Object key, long amount, DataComponentPatch dataComponentPatch) {
        if (key instanceof Item) {
            Item item = (Item)key;
            ItemStack itemStack = dataComponentPatch != null ? new ItemStack((Holder)BuiltInRegistries.ITEM.getHolder(BuiltInRegistries.ITEM.getKey((Object)item)).get(), 1, dataComponentPatch) : new ItemStack((Holder)BuiltInRegistries.ITEM.getHolder(BuiltInRegistries.ITEM.getKey((Object)item)).get(), 1);
            return new ItemStackType(itemStack, amount);
        }
        return null;
    }

    @Override
    public ItemStack getStack() {
        this.stack.setCount(BDMath.clampLongToInt(this.stackSize));
        return this.stack;
    }

    @Override
    public void setStack(ItemStack stack) {
        this.stack = stack.copy();
        this.stackSize = stack.getCount();
        this.NeedRecalHash = true;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public IStackType<ItemStack> getEmpty() {
        return new ItemStackType();
    }

    @Override
    public Class<ItemStack> getStackClass() {
        return ItemStack.class;
    }

    @Override
    public Class<?> getSourceClass() {
        return Item.class;
    }

    @Override
    public Object getSource() {
        return ItemStack.EMPTY.getItem();
    }

    @Override
    public String getModId() {
        return BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getNamespace();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty() || this.stackSize <= 0L;
    }

    @Override
    public boolean isEmptyStack() {
        return this.stack.isEmpty();
    }

    @Override
    public ItemStack getEmptyStack() {
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack copyStack() {
        return this.stack.copyWithCount(BDMath.clampLongToInt(this.stackSize));
    }

    @Override
    public ItemStack copyStackWithCount(long count) {
        return this.stack.copyWithCount(BDMath.clampLongToInt(count));
    }

    @Override
    public IStackType<ItemStack> copy() {
        ItemStackType copy = new ItemStackType(this.stack.copy(), this.stackSize);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<ItemStack> copyWithCount(long count) {
        ItemStackType copy = new ItemStackType(this.stack.copy(), count);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public long getStackAmount() {
        return this.stackSize;
    }

    @Override
    public void setStackAmount(long amount) {
        this.stackSize = amount;
    }

    @Override
    public void grow(long amount) {
        this.setStackAmount(this.getStackAmount() + amount);
    }

    @Override
    public void shrink(long amount) {
        this.grow(-amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return Math.min((long)this.stack.getMaxStackSize(), this.getCustomMaxStackSize());
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public ItemStack splitStack(long amount) {
        if (amount <= 0L) {
            return ItemStack.EMPTY;
        }
        int splitAmount = BDMath.clampLongToInt(Math.min(amount, this.stackSize));
        ItemStack split = this.stack.copy();
        split.setCount(splitAmount);
        this.shrink(splitAmount);
        return split;
    }

    @Override
    public IStackType<ItemStack> split(long amount) {
        if (amount <= 0L) {
            return new ItemStackType();
        }
        long splitAmount = Math.min(amount, this.stackSize);
        ItemStack split = this.stack.copy();
        this.shrink(splitAmount);
        return new ItemStackType(split, splitAmount);
    }

    @Override
    public boolean isSame(IStackType<ItemStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ItemStack.isSameItem((ItemStack)this.stack, (ItemStack)other.copyStackWithCount(1L));
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<ItemStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)other.copyStackWithCount(1L));
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.getTypeId());
        boolean hasItem = !this.stack.isEmpty();
        buf.writeBoolean(hasItem);
        if (hasItem) {
            buf.writeVarLong(this.stackSize);
            ItemStack copy = this.stack.copyWithCount(1);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)copy);
        }
    }

    public ItemStackType deserialize(RegistryFriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        boolean hasItem = buf.readBoolean();
        if (!hasItem) {
            return new ItemStackType(ItemStack.EMPTY);
        }
        long count = buf.readVarLong();
        ItemStack stack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
        return new ItemStackType(stack, count);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider levelRegistryAccess) {
        CompoundTag tag = new CompoundTag();
        tag.putString("Type", ID.toString());
        tag.putLong("Amount", this.getStackAmount());
        tag.put("Stack", this.stack.copyWithCount(1).saveOptional(levelRegistryAccess));
        return tag;
    }

    public ItemStackType deserializeNBT(CompoundTag nbt, HolderLookup.Provider levelRegistryAccess) {
        ItemStackType stack = new ItemStackType(ItemStack.parseOptional((HolderLookup.Provider)levelRegistryAccess, (CompoundTag)nbt.getCompound("Stack")));
        stack.setStackAmount(nbt.getLong("Amount"));
        return stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        PoseStack poseStack = gui.pose();
        poseStack.pushPose();
        this.stack.setCount(1);
        gui.renderFakeItem(this.stack, x, y);
        gui.renderItemDecorations(Minecraft.getInstance().font, this.stack, x, y, "");
        poseStack.popPose();
        String countText = this.getCountText(this.getStackAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.pose();
        poseStackText.pushPose();
        poseStackText.translate(0.0f, 0.0f, 200.0f);
        poseStackText.scale(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.getInstance().font.width(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!this.stack.isEmpty()) {
            gui.drawString(Minecraft.getInstance().font, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.popPose();
    }

    @Override
    public String getCountText(long count) {
        if (count < 0L) {
            return "";
        }
        return StringFormat.formatCount(count);
    }

    @Override
    public Component getDisplayName() {
        return this.stack.getDisplayName();
    }

    @Override
    public List<Component> getTooltipLines(Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        List tooltips = this.stack.getTooltipLines(tooltipContext, player, tooltipFlag);
        tooltips.add(Component.translatable((String)"istack.beyonddimensions.storage_num.item", (Object[])new Object[]{this.getStackAmount()}));
        return tooltips;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage() {
        return this.stack.getTooltipImage();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics gui, Font font, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        gui.renderTooltip(minecraft.font, this.getTooltipLines(Item.TooltipContext.of((Level)minecraft.level), (Player)minecraft.player, ClientTooltipFlag.of((TooltipFlag)(minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL))), this.getTooltipImage(), ItemStack.EMPTY, mouseX, mouseY);
    }

    public boolean equals(Object other) {
        if (other instanceof ItemStackType) {
            ItemStackType otherStack = (ItemStackType)other;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        if (this.NeedRecalHash) {
            this.hashCodeCache = ItemStack.hashItemAndComponents((ItemStack)this.stack);
            this.NeedRecalHash = false;
        }
        return this.hashCodeCache;
    }
}

