/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Storage;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidUnifiedStorageHandler
implements IFluidHandler {
    private UnifiedStorage storage;

    public FluidUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getTanks() {
        return this.storage.getTypeIdIndexList(FluidStackType.ID).map(list -> this.storage.isFullSlotsSize() ? list.size() : list.size() + 1).orElse(this.storage.isFullSlotsSize() ? 0 : 1);
    }

    public FluidStack getFluidInTank(int slot) {
        return this.storage.getTypeIdIndexList(FluidStackType.ID).filter(slots -> slot >= 0 && slot < slots.size()).map(slots -> (Integer)slots.get(slot)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (FluidStackType)this.storage.getStackBySlot((int)actualIndex)).map(FluidStackType::getStack).orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity(int tank) {
        return BDMath.clampLongToInt(this.storage.getSlotCapacity(0));
    }

    public boolean isFluidValid(int slot, FluidStack fluidStack) {
        return true;
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        if (fluidStack.isEmpty()) {
            return 0;
        }
        int allAmount = fluidStack.getAmount();
        int remaining = (int)this.storage.insert(new FluidStackType(fluidStack.copy()), fluidAction.simulate()).getStackAmount();
        return allAmount - remaining;
    }

    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return ((FluidStackType)this.storage.extract(new FluidStackType(fluidStack.copy()), fluidAction.simulate())).copyStack();
    }

    public FluidStack drain(int count, IFluidHandler.FluidAction fluidAction) {
        return ((FluidStackType)this.storage.extract(new FluidStackType(this.getFluidInTank(0).copyWithAmount(count)), fluidAction.simulate())).copyStack();
    }
}

