/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class NetedBlockEntity
extends BlockEntity {
    protected int netId = -1;

    public NetedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public int getNetId() {
        return this.netId;
    }

    public void setNetId(int id) {
        this.netId = id;
        this.setChanged();
    }

    public void clearNetId() {
        this.netId = -1;
        this.setChanged();
    }

    public void setNetIdFromPlayer(ServerPlayer player) {
        DimensionsNet net = DimensionsNet.getNetFromPlayer((Player)player);
        if (net != null) {
            this.netId = net.getId();
            this.setChanged();
        }
    }

    public void setNetIdFromPlayerOrClean(ServerPlayer player) {
        DimensionsNet net = DimensionsNet.getNetFromPlayer((Player)player);
        if (net != null) {
            this.netId = net.getId();
            this.setChanged();
        } else {
            this.netId = -1;
            this.setChanged();
        }
    }

    public DimensionsNet getNet() {
        if (this.netId >= 0) {
            if (this.getLevel() instanceof ServerLevel) {
                return DimensionsNet.getNetFromId(this.netId, this.getLevel().getServer());
            }
        } else {
            return null;
        }
        return null;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.netId = tag.getInt("netId");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("netId", this.netId);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

