/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataComponents;

import com.mojang.serialization.Codec;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModDataComponents {
    public static DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"beyonddimensions");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> NET_ID_DATA = ModDataComponents.register("net_id", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Long>> LONG_DATA = ModDataComponents.register("long_data", builder -> builder.persistent((Codec)Codec.LONG).networkSynchronized(ByteBufCodecs.VAR_LONG));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Long>> TIME_LINE = ModDataComponents.register("time_line", builder -> builder.persistent((Codec)Codec.LONG).networkSynchronized(ByteBufCodecs.VAR_LONG));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<NonNullList<ItemStack>>> CRAFT_SLOTS = ModDataComponents.register("craft_slots", builder -> builder.persistent(NonNullList.codecOf((Codec)ItemStack.OPTIONAL_CODEC)).networkSynchronized(ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC)));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<IStackType>>> ISTACK_SLOTS = ModDataComponents.register("istack_slots", builder -> builder.persistent(IStackType.CODEC.listOf()).networkSynchronized(ByteBufCodecs.collection(ArrayList::new, (StreamCodec)new StreamCodec<RegistryFriendlyByteBuf, IStackType>(){

        public void encode(RegistryFriendlyByteBuf buf, IStackType stackType) {
            stackType.serialize(buf);
        }

        public IStackType decode(RegistryFriendlyByteBuf byteBuf) {
            return IStackType.deserializeCommon(byteBuf);
        }
    })));

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> register(String name, UnaryOperator<DataComponentType.Builder<T>> builder) {
        return DATA_COMPONENTS.register(name, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
    }

    public static void register(IEventBus eventBus) {
        DATA_COMPONENTS.register(eventBus);
    }
}

