/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Item.Custom.NetTerminalItem;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenu;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class DimensionsCraftMenuTerminal
extends DimensionsCraftMenu {
    private ItemStack terminalStack = null;
    private BlockPos entityPos = null;
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final Supplier<MenuType<DimensionsCraftMenuTerminal>> Dimensions_Craft_Menu_Terminal = MENU_TYPES.register("dimensions_craft_menu_terminal", () -> IMenuTypeExtension.create(DimensionsCraftMenuTerminal::new));

    public DimensionsCraftMenuTerminal(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, new DimensionsNet(true), null, null, null);
    }

    public DimensionsCraftMenuTerminal(int id, Inventory playerInventory, DimensionsNet data, NonNullList<ItemStack> craftItems, @Nullable ItemStack terminalItem, @Nullable BlockPos entityPos) {
        super(Dimensions_Craft_Menu_Terminal.get(), id, playerInventory, data, craftItems, entityPos);
        if (!this.player.level().isClientSide) {
            this.terminalStack = terminalItem;
            this.entityPos = entityPos;
        }
    }

    @Override
    protected void initCraftSlots(Inventory playerInventory, @Nullable TransientCraftingContainer craftSlots) {
        super.initCraftSlots(playerInventory, craftSlots);
        DimensionsCraftMenu.slotChangedCraftingGrid(this, this.player.level(), this.player, (CraftingContainer)craftSlots, this.resultSlots, this.resultSlotIndex);
    }

    @Override
    public void removed(Player player) {
        ItemStack itemstack;
        if (player instanceof ServerPlayer && !(itemstack = this.getCarried()).isEmpty()) {
            if (player.isAlive() && !((ServerPlayer)player).hasDisconnected()) {
                player.getInventory().placeItemBackInInventory(itemstack);
            } else {
                player.drop(itemstack, false);
            }
            this.setCarried(ItemStack.EMPTY);
        }
        if (player instanceof ServerPlayer) {
            NonNullList nonNullList = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
            for (int i = 0; i < this.craftSlots.getItems().size(); ++i) {
                ItemStack stack = (ItemStack)this.craftSlots.getItems().get(i);
                nonNullList.set(i, (Object)stack);
            }
            if (this.terminalStack != null && this.terminalStack.getItem() instanceof NetTerminalItem) {
                this.terminalStack.set(ModDataComponents.CRAFT_SLOTS, (Object)nonNullList);
            }
        }
    }

    @Override
    public boolean stillValid(Player player) {
        if (this.entityPos != null) {
            BlockEntity be = player.level().getBlockEntity(this.entityPos);
            return be != null && !be.isRemoved();
        }
        return this.terminalStack != null && !this.terminalStack.isEmpty();
    }
}

