/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.ButtonName;
import com.wintercogs.beyonddimensions.Api.DataBase.ButtonState;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Config;
import com.wintercogs.beyonddimensions.Menu.BDDisorderedContainerMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Packet.SyncStoragePacket;
import com.wintercogs.beyonddimensions.Unit.TinyPinyinUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DimensionsNetMenu
extends BDDisorderedContainerMenu {
    public int maxLines = 6;
    public int lineData = 0;
    public int maxLineData = 0;
    private String searchText = "";
    private HashMap<ButtonName, ButtonState> buttonStateMap = new HashMap();
    public UnifiedStorage viewerStorage;
    private ArrayList<Integer> cacheIndex;
    private ArrayList<IStackType> lastStorage;
    public boolean hasShiftDown = false;
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final Supplier<MenuType<DimensionsNetMenu>> Dimensions_Net_Menu = MENU_TYPES.register("dimensions_net_menu", () -> IMenuTypeExtension.create(DimensionsNetMenu::new));
    public static int BREAKPOINT_COUNTER = 0;

    public DimensionsNetMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(Dimensions_Net_Menu.get(), id, playerInventory, new DimensionsNet(true));
    }

    public DimensionsNetMenu(MenuType<?> menuType, int id, Inventory playerInventory, DimensionsNet data) {
        super(menuType, id, playerInventory, data.getUnifiedStorage());
        if (this.player.level().isClientSide()) {
            this.maxLines = Config.uiPageNum;
            this.searchText = Config.uiSearch;
        }
        this.viewerStorage = new DimensionsNet(true).getUnifiedStorage();
        if (!this.player.level().isClientSide()) {
            this.lastStorage = new ArrayList();
        }
        this.addStorageSlots();
        this.addPlayerInv(playerInventory);
    }

    protected void addStorageSlots() {
        for (int row = 0; row < 99; ++row) {
            for (int col = 0; col < 9; ++col) {
                StoredStackSlot newSlot = new StoredStackSlot(this.viewerStorage, -1, 8 + col * 18, 25 + row * 18);
                if (row >= this.getLines()) {
                    newSlot.setActive(false);
                }
                this.addSlot(newSlot);
            }
        }
    }

    protected void addPlayerInv(Inventory playerInventory) {
        this.inventoryStartIndex = this.slots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 25 + (this.getLines() - 1) * 18 + 26 + 6 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 25 + (this.getLines() - 1) * 18 + 26 + 6 + 54 + 4));
        }
        this.inventoryEndIndex = this.slots.size();
    }

    public void rebuildSlots() {
        int sSlotNum = 0;
        for (Slot slot : this.slots) {
            if (!(slot instanceof StoredStackSlot)) continue;
            StoredStackSlot sSlot = (StoredStackSlot)slot;
            if (sSlotNum / 9 < this.getLines()) {
                sSlot.setActive(true);
            } else {
                sSlot.setActive(false);
            }
            ++sSlotNum;
        }
        int slotNum = 0;
        for (int i = this.inventoryStartIndex; i < this.inventoryEndIndex; ++i) {
            Slot slot = (Slot)this.slots.get(i);
            if (slot == null) continue;
            slot.y = slotNum / 9 < 3 ? 25 + (this.getLines() - 1) * 18 + 26 + 6 + slotNum / 9 * 18 : 25 + (this.getLines() - 1) * 18 + 26 + 6 + 54 + 4;
            ++slotNum;
        }
    }

    public int getLines() {
        return this.maxLines;
    }

    public void reduceLines() {
        --this.maxLines;
    }

    public void addLines() {
        ++this.maxLines;
    }

    public void setLines(int lines) {
        this.maxLines = lines;
    }

    public void updateViewerStorage() {
        this.viewerStorage.clearStorage();
        for (IStackType stack : this.storage.getStorage()) {
            this.viewerStorage.insert(stack.copy(), false);
        }
        this.buildIndexList(new ArrayList<IStackType>(this.viewerStorage.getStorage()), true);
    }

    public void updateOnlyCountAndNewViewer() {
        HashMap<IStackType, Long> storageMap = new HashMap<IStackType, Long>();
        for (IStackType stack : this.storage.getStorage()) {
            storageMap.put(stack, stack.getStackAmount());
        }
        for (IStackType viewerStack : this.viewerStorage.getStorage()) {
            long amount = storageMap.getOrDefault(viewerStack, 0L);
            viewerStack.setStackAmount(amount);
        }
    }

    public void buildIndexList(ArrayList<IStackType> itemStorage, boolean needsUpdateCacheIndex) {
        if (!this.player.level().isClientSide()) {
            return;
        }
        if (needsUpdateCacheIndex || this.cacheIndex == null) {
            this.cacheIndex = this.buildStorageWithCurrentState(new ArrayList<IStackType>(itemStorage));
        }
        this.updateScrollLineData(this.cacheIndex.size());
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < this.getLines() * 9; ++i) {
            if (i + this.lineData * 9 < this.cacheIndex.size()) {
                int index = this.cacheIndex.get(i + this.lineData * 9);
                indexList.add(index);
                continue;
            }
            indexList.add(-1);
        }
        this.loadIndexList(indexList);
    }

    public void loadIndexList(ArrayList<Integer> list) {
        for (int i = 0; i < list.size(); ++i) {
            ((StoredStackSlot)((Object)this.slots.get(i))).setTheSlotIndex(list.get(i));
        }
    }

    public void loadSearchText(String text) {
        this.searchText = text.toLowerCase(Locale.ENGLISH);
    }

    public ArrayList<Integer> buildStorageWithCurrentState(ArrayList<IStackType> unifiedStorage) {
        ArrayList cache = new ArrayList();
        ArrayList<Integer> cacheIndex = new ArrayList<Integer>();
        for (int i = 0; i < unifiedStorage.size(); ++i) {
            boolean matchesSearch;
            IStackType stack = unifiedStorage.get(i).copy();
            if (stack == null || stack.isEmpty()) continue;
            String displayName = stack.getDisplayName().getString().toLowerCase(Locale.ENGLISH);
            String allPinyin = TinyPinyinUtils.getAllPinyin(displayName, false).toLowerCase(Locale.ENGLISH);
            String firstPinyin = TinyPinyinUtils.getFirstPinYin(displayName).toLowerCase(Locale.ENGLISH);
            if (this.searchText == null || this.searchText.isEmpty()) {
                matchesSearch = true;
            } else {
                String lowerSearch = this.searchText.toLowerCase(Locale.ENGLISH);
                int atIndex = lowerSearch.indexOf(35);
                if (atIndex >= 0) {
                    String mainPart = atIndex > 0 ? lowerSearch.substring(0, atIndex) : "";
                    String tooltipPart = atIndex + 1 < lowerSearch.length() ? lowerSearch.substring(atIndex + 1) : "";
                    boolean matchesMain = mainPart.isEmpty() || displayName.contains(mainPart) || allPinyin.contains(mainPart) || firstPinyin.contains(mainPart);
                    boolean matchesTooltip = tooltipPart.isEmpty() || this.checkTooltipMatches(stack, tooltipPart);
                    matchesSearch = matchesMain && matchesTooltip;
                } else {
                    boolean bl = matchesSearch = displayName.contains(lowerSearch) || allPinyin.contains(lowerSearch) || firstPinyin.contains(lowerSearch);
                }
            }
            if (!matchesSearch) continue;
            cache.add(stack);
            cacheIndex.add(i);
        }
        ButtonState sortState = Config.uiSortButton;
        if (sortState != ButtonState.SORT_DEFAULT) {
            Comparator<IStackType> comparator = sortState == ButtonState.SORT_NAME ? Comparator.comparing(item -> item.getDisplayName().getString()) : (sortState == ButtonState.SORT_QUANTITY ? Comparator.comparingLong(IStackType::getStackAmount) : (sortState == ButtonState.SORT_MODID ? Comparator.comparing(IStackType::getModId) : Comparator.comparing(item -> item.getDisplayName().getString())));
            ArrayList finalCache = cache;
            List indices = IntStream.range(0, cache.size()).parallel().boxed().sorted((a, b) -> comparator.compare((IStackType)finalCache.get((int)a), (IStackType)finalCache.get((int)b))).collect(Collectors.toList());
            ArrayList<Integer> sortedIndices = new ArrayList<Integer>(cacheIndex.size());
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                sortedIndices.add(cacheIndex.get(index));
            }
            cacheIndex = sortedIndices;
        }
        if (Config.uiReverseButton == ButtonState.ENABLED) {
            Collections.reverse(cacheIndex);
        }
        return cacheIndex;
    }

    private boolean checkTooltipMatches(IStackType stack, String matchText) {
        List<Component> toolTips = stack.getTooltipLines(Item.TooltipContext.of((Level)this.player.level()), this.player, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        return toolTips.stream().anyMatch(tooltip -> {
            String tooltipText = tooltip.getString().toLowerCase(Locale.ENGLISH);
            String allPinyin = TinyPinyinUtils.getAllPinyin(tooltipText, false).toLowerCase(Locale.ENGLISH);
            String firstPinyin = TinyPinyinUtils.getFirstPinYin(tooltipText).toLowerCase(Locale.ENGLISH);
            return tooltipText.contains(matchText) || allPinyin.contains(matchText) || firstPinyin.contains(matchText);
        });
    }

    public void updateScrollLineData(int dataSize) {
        this.maxLineData = dataSize / 9;
        if (dataSize % 9 != 0) {
            ++this.maxLineData;
        }
        this.maxLineData -= this.getLines();
        this.maxLineData = Math.max(this.maxLineData, 0);
        this.lineData = Math.max(this.lineData, 0);
        this.lineData = Math.min(this.lineData, this.maxLineData);
    }

    @Override
    protected void updateChange() {
        ArrayList changedItem = new ArrayList();
        ArrayList<Long> changedCount = new ArrayList<Long>();
        HashMap<IStackType, Long> lastMap = new HashMap<IStackType, Long>();
        for (IStackType iStackType : this.lastStorage) {
            lastMap.put(iStackType, lastMap.getOrDefault(iStackType, 0L) + iStackType.getStackAmount());
        }
        HashMap<IStackType, Long> nowMap = new HashMap<IStackType, Long>();
        for (IStackType iStackType : this.storage.getStorage()) {
            nowMap.put(iStackType, nowMap.getOrDefault(iStackType, 0L) + iStackType.getStackAmount());
        }
        this.refreshLast();
        HashSet hashSet = new HashSet();
        hashSet.addAll(lastMap.keySet());
        hashSet.addAll(nowMap.keySet());
        for (IStackType key : hashSet) {
            long lastCount = lastMap.getOrDefault(key, 0L);
            long nowCount = nowMap.getOrDefault(key, 0L);
            long delta = nowCount - lastCount;
            if (delta == 0L) continue;
            changedItem.add(key.copy());
            changedCount.add(delta);
        }
        if (!changedItem.isEmpty()) {
            int n = 921600;
            ArrayList<SyncStoragePacket> packets = new ArrayList<SyncStoragePacket>();
            ArrayList<Integer> entrySizes = new ArrayList<Integer>();
            for (int i = 0; i < changedItem.size(); ++i) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                RegistryFriendlyByteBuf registryBuf = new RegistryFriendlyByteBuf((ByteBuf)buf, this.player.level().registryAccess(), ConnectionType.OTHER);
                IStackType stack = (IStackType)changedItem.get(i);
                if (stack != null) {
                    stack.serialize(registryBuf);
                }
                buf.writeLong(((Long)changedCount.get(i)).longValue());
                entrySizes.add(buf.readableBytes());
            }
            ArrayList<IStackType> batchItems = new ArrayList<IStackType>();
            ArrayList<Long> batchCounts = new ArrayList<Long>();
            int currentSize = 0;
            for (int i = 0; i < changedItem.size(); ++i) {
                int entrySize = (Integer)entrySizes.get(i);
                if (currentSize + entrySize > 921600) {
                    packets.add(new SyncStoragePacket(new ArrayList<IStackType>(batchItems), new ArrayList<Long>(batchCounts), new ArrayList<Integer>()));
                    batchItems.clear();
                    batchCounts.clear();
                    currentSize = 0;
                }
                batchItems.add((IStackType)changedItem.get(i));
                batchCounts.add((Long)changedCount.get(i));
                currentSize += entrySize;
            }
            if (!batchItems.isEmpty()) {
                packets.add(new SyncStoragePacket(batchItems, batchCounts, new ArrayList<Integer>()));
            }
            for (SyncStoragePacket packet : packets) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    protected void initUpdate() {
    }

    public void refreshLast() {
        this.lastStorage.clear();
        for (IStackType stack : this.storage.getStorage()) {
            this.lastStorage.add(stack.copy());
        }
    }

    @Override
    public boolean stillValid(Player player) {
        return true;
    }
}

