/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.NetControlAction;
import com.wintercogs.beyonddimensions.Api.DataBase.PlayerPermissionInfo;
import com.wintercogs.beyonddimensions.Menu.BDOrderedContainerMenu;
import com.wintercogs.beyonddimensions.Packet.PlayerPermissionInfoPacket;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NetControlMenu
extends BDOrderedContainerMenu {
    private DimensionsNet net = new DimensionsNet(true);
    public HashMap<UUID, PlayerPermissionInfo> playerInfo = new HashMap();
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final Supplier<MenuType<NetControlMenu>> Net_Control_Menu = MENU_TYPES.register("net_control_menu", () -> IMenuTypeExtension.create(NetControlMenu::new));

    public NetControlMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory);
    }

    public NetControlMenu(int containerId, Inventory playerInventory) {
        super(Net_Control_Menu.get(), containerId, playerInventory, null);
        if (!this.player.level().isClientSide()) {
            this.net = DimensionsNet.getNetFromPlayer(this.player);
            this.playerInfo = this.net.getPlayerPermissionInfoMap(this.player.getServer());
        }
    }

    public void handlePlayerAction(UUID receiver, NetControlAction action) {
        if (action == NetControlAction.SetOwner) {
            if (this.net.isOwner(this.player) && !this.player.getUUID().equals(receiver)) {
                this.net.setOwner(receiver);
            }
        } else if (action == NetControlAction.SetManager) {
            if (this.net.isOwner(this.player) && !this.net.isManager(receiver)) {
                this.net.addManager(receiver);
            }
        } else if (action == NetControlAction.RemoveManager) {
            if (this.net.isOwner(this.player) && this.net.isManager(receiver) && !this.net.isOwner(receiver)) {
                this.net.removeManager(receiver);
            }
        } else if (action == NetControlAction.RemovePlayer) {
            if (this.net.isManager(this.player) && !this.net.isManager(receiver)) {
                this.net.removePlayer(receiver);
            } else if (this.player.getUUID().equals(receiver) && !this.net.isOwner(receiver)) {
                this.net.removePlayer(receiver);
            } else if (this.net.isOwner(this.player) && !this.player.getUUID().equals(receiver)) {
                this.net.removePlayer(receiver);
            }
        }
    }

    @Override
    protected void updateChange() {
        if (!this.net.getPlayerPermissionInfoMap(this.player.getServer()).equals(this.playerInfo)) {
            this.playerInfo = this.net.getPlayerPermissionInfoMap(this.player.getServer());
            this.sendPlayerInfo();
        }
    }

    @Override
    protected void initUpdate() {
        this.sendPlayerInfo();
    }

    public void sendPlayerInfo() {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new PlayerPermissionInfoPacket(this.playerInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void loadPlayerInfo(HashMap<UUID, PlayerPermissionInfo> playerInfo) {
        this.playerInfo = playerInfo;
    }

    @Override
    public boolean stillValid(Player player) {
        return true;
    }
}

