/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network;

import com.mojang.logging.LogUtils;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.GUI.NetMenuType;
import com.wintercogs.beyonddimensions.Item.Custom.NetTerminalItem;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenu;
import com.wintercogs.beyonddimensions.Menu.DimensionsNetMenu;
import com.wintercogs.beyonddimensions.Menu.NetControlMenu;
import com.wintercogs.beyonddimensions.Menu.NetEnergyMenu;
import com.wintercogs.beyonddimensions.Menu.NetInterfaceBaseMenu;
import com.wintercogs.beyonddimensions.Packet.CallServerPlayerInfoPacket;
import com.wintercogs.beyonddimensions.Packet.CallSeverClickPacket;
import com.wintercogs.beyonddimensions.Packet.CallSeverStoragePacket;
import com.wintercogs.beyonddimensions.Packet.ClickTransferCraftButtonPacket;
import com.wintercogs.beyonddimensions.Packet.CraftReturnPacket;
import com.wintercogs.beyonddimensions.Packet.EnergyStoragePacket;
import com.wintercogs.beyonddimensions.Packet.FlagSlotSetPacket;
import com.wintercogs.beyonddimensions.Packet.NetControlActionPacket;
import com.wintercogs.beyonddimensions.Packet.OpenNetGuiPacket;
import com.wintercogs.beyonddimensions.Packet.PlayerPermissionInfoPacket;
import com.wintercogs.beyonddimensions.Packet.PopModeButtonPacket;
import com.wintercogs.beyonddimensions.Packet.RecipeFillC2SPacket;
import com.wintercogs.beyonddimensions.Packet.StoragePacket;
import com.wintercogs.beyonddimensions.Packet.SyncFlagPacket;
import com.wintercogs.beyonddimensions.Packet.SyncStoragePacket;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;

public class ServerPayloadHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleOpenNetGuiPacket(OpenNetGuiPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
            if (net != null) {
                NetMenuType targetMenu = packet.target();
                if (targetMenu == NetMenuType.NET_CRAFT_MENU) {
                    player.openMenu((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, _player) -> new DimensionsCraftMenu(DimensionsCraftMenu.Dimensions_Craft_Menu.get(), containerId, playerInventory, net, null, null), (Component)Component.translatable((String)"menu.title.beyonddimensions.dimensionnetmenu")));
                } else if (targetMenu == NetMenuType.NET_MENU) {
                    player.openMenu((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, _player) -> new DimensionsNetMenu(DimensionsNetMenu.Dimensions_Net_Menu.get(), containerId, playerInventory, net), (Component)Component.translatable((String)"menu.title.beyonddimensions.dimensionnetmenu")));
                } else if (targetMenu == NetMenuType.NET_CRAFT_TERMINAL) {
                    ItemStack terminalStack = null;
                    if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof NetTerminalItem) {
                        terminalStack = player.getItemInHand(InteractionHand.MAIN_HAND);
                    } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof NetTerminalItem) {
                        terminalStack = player.getItemInHand(InteractionHand.OFF_HAND);
                    } else {
                        for (ItemStack itemStack : player.getInventory().items) {
                            if (!(itemStack.getItem() instanceof NetTerminalItem)) continue;
                            terminalStack = itemStack;
                            break;
                        }
                        if (terminalStack == null && BeyondDimensions.CuriosLoaded) {
                            terminalStack = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(iCuriosItemHandler -> iCuriosItemHandler.findFirstCurio(itemStack -> itemStack.getItem() instanceof NetTerminalItem && itemStack.has(ModDataComponents.NET_ID_DATA) && (Integer)itemStack.get(ModDataComponents.NET_ID_DATA) >= 0)).map(slotResult -> slotResult.stack()).orElse(null);
                        }
                    }
                    if (terminalStack != null) {
                        if (terminalStack.get(ModDataComponents.CRAFT_SLOTS) == null) {
                            terminalStack.set(ModDataComponents.CRAFT_SLOTS, (Object)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY));
                        }
                        NetTerminalItem.contextMap.put(player, new NetTerminalItem.MenuTriggerContext(InteractionHand.MAIN_HAND, terminalStack));
                        player.openMenu((MenuProvider)((NetTerminalItem)terminalStack.getItem()));
                    }
                }
            }
        });
    }

    public void handleItemStoragePacket(StoragePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleCallSeverStoragePacket(CallSeverStoragePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleSyncItemStoragePacket(SyncStoragePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleCallSeverClickPacket(CallSeverClickPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof DimensionsNetMenu) {
                DimensionsNetMenu menu = (DimensionsNetMenu)patt0$temp;
                menu.customClickHandler(packet.slotIndex(), packet.clickItem(), packet.button(), packet.shiftDown());
                menu.broadcastChanges();
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new CallSeverClickPacket(1, new ItemStackType(ItemStack.EMPTY), 1, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            AbstractContainerMenu patt1$temp = player.containerMenu;
            if (patt1$temp instanceof NetInterfaceBaseMenu) {
                NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)patt1$temp;
                menu.customClickHandler(packet.slotIndex(), packet.clickItem(), packet.button(), packet.shiftDown());
                menu.broadcastChanges();
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new CallSeverClickPacket(1, new ItemStackType(ItemStack.EMPTY), 1, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
        });
    }

    public void handleCallServerPlayerInfoPacket(CallServerPlayerInfoPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (!(player.containerMenu instanceof NetControlMenu)) {
                return;
            }
            NetControlMenu menu = (NetControlMenu)player.containerMenu;
            menu.sendPlayerInfo();
        });
    }

    public void handlePlayerPermissionInfoPacket(PlayerPermissionInfoPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleNetControlActionPacket(NetControlActionPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (!(player.containerMenu instanceof NetControlMenu)) {
                return;
            }
            NetControlMenu menu = (NetControlMenu)player.containerMenu;
            menu.handlePlayerAction(packet.receiver(), packet.action());
        });
    }

    public void handleSyncFlagPacket(SyncFlagPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (!(player.containerMenu instanceof NetInterfaceBaseMenu)) {
                return;
            }
            NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)player.containerMenu;
        });
    }

    public void handlePopModeButtonPacket(PopModeButtonPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof NetInterfaceBaseMenu) {
                NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)patt0$temp;
                menu.popMode = packet.popMode();
                menu.be.popMode = packet.popMode();
                return;
            }
            AbstractContainerMenu patt1$temp = player.containerMenu;
            if (patt1$temp instanceof NetEnergyMenu) {
                NetEnergyMenu menu = (NetEnergyMenu)patt1$temp;
                menu.popMode = packet.popMode();
                menu.be.popMode = packet.popMode();
                return;
            }
        });
    }

    public void handleFlagSlotSetPacket(FlagSlotSetPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof NetInterfaceBaseMenu) {
                NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)patt0$temp;
                menu.setFlagSlot(packet.index(), packet.clickStack(), packet.flagStack());
                menu.broadcastChanges();
                return;
            }
        });
    }

    public void handleEnergyStoragePacket(EnergyStoragePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleRecipeFillC2SPacket(RecipeFillC2SPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof DimensionsCraftMenu) {
                DimensionsCraftMenu menu = (DimensionsCraftMenu)patt0$temp;
                menu.transferRecipe(packet.inputs());
            }
        });
    }

    public void handleClickTransferCraftButtonPacket(ClickTransferCraftButtonPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof DimensionsCraftMenu) {
                DimensionsCraftMenu menu = (DimensionsCraftMenu)patt0$temp;
                menu.cleanCraftSlots(packet.toStorage());
            }
        });
    }

    public void handleCraftReturnPacket(CraftReturnPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof DimensionsCraftMenu) {
                DimensionsCraftMenu menu = (DimensionsCraftMenu)patt0$temp;
                menu.firstCraftReturnDir = packet.dir();
            }
        });
    }
}

