/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Unit.CapabilityHelper;
import com.wintercogs.beyonddimensions.Unit.StackHandlerWrapperHelper;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;

public class NetInterfaceBlockEntity
extends NetedBlockEntity
implements ITickable {
    public final int transHold = 9;
    public int transTime = 0;
    private final StackTypedHandler fakeStackHandler = new StackTypedHandler(9){

        @Override
        public void onChange() {
            if (!((NetInterfaceBlockEntity)NetInterfaceBlockEntity.this).field_145850_b.field_72995_K) {
                // empty if block
            }
        }
    };
    private final StackTypedHandler stackHandler = new StackTypedHandler(9){

        @Override
        public void onChange() {
            if (!((NetInterfaceBlockEntity)NetInterfaceBlockEntity.this).field_145850_b.field_72995_K) {
                // empty if block
            }
        }
    };
    public boolean popMode = false;
    private final EnumFacing[] directions = EnumFacing.values();
    private final Multimap<ResourceLocation, Object> handlerCache = ArrayListMultimap.create();
    private boolean needsCapabilityUpdate = true;

    public StackTypedHandler getStackHandler() {
        return this.stackHandler;
    }

    public StackTypedHandler getFakeStackHandler() {
        return this.fakeStackHandler;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.transTime;
        if (this.transTime >= 9) {
            if (this.getNetId() != -1) {
                this.transferToNet();
                this.transferFromNet();
            }
            if (this.popMode) {
                this.updateCapabilityCache();
                this.popStack();
            }
            this.transTime = 0;
        }
    }

    public void updateCapabilityCache() {
        if (!this.needsCapabilityUpdate) {
            return;
        }
        this.handlerCache.clear();
        for (EnumFacing dir : this.directions) {
            BlockPos targetPos = this.field_174879_c.func_177972_a(dir);
            TileEntity neighbor = this.field_145850_b.func_175625_s(targetPos);
            if (neighbor == null || neighbor instanceof NetedBlockEntity) continue;
            CapabilityHelper.BlockCapabilityMap.forEach((resLoc, cap) -> {
                Object handler = neighbor.getCapability(cap, dir.func_176734_d());
                if (handler != null) {
                    this.handlerCache.put(resLoc, handler);
                }
            });
        }
        this.needsCapabilityUpdate = false;
    }

    public void setNeedsCapabilityUpdate() {
        this.needsCapabilityUpdate = true;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        for (Map.Entry<ResourceLocation, Capability<? extends Object>> entry : CapabilityHelper.BlockCapabilityMap.entrySet()) {
            if (entry.getValue() != capability) continue;
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        for (Map.Entry<ResourceLocation, Capability<? extends Object>> entry : CapabilityHelper.BlockCapabilityMap.entrySet()) {
            Function<StackTypedHandler, Object> constructor;
            if (entry.getValue() != cap || (constructor = StackTypedHandler.typedHandlerMap.get(entry.getKey())) == null) continue;
            return (T)constructor.apply(this.stackHandler);
        }
        return (T)super.getCapability(cap, side);
    }

    public void transferToNet() {
        DimensionsNet net = this.getNet();
        if (net != null) {
            for (int i = 0; i < 9; ++i) {
                IStackType stack;
                IStackType flag = this.fakeStackHandler.getStackBySlot(i);
                if (flag != null && !flag.isEmpty() && flag.isSameTypeSameComponents(this.stackHandler.getStackBySlot(i)) || (stack = this.stackHandler.getStackBySlot(i)) == null || stack.isEmpty()) continue;
                net.getUnifiedStorage().insert(stack.copy(), false);
                if (i < this.stackHandler.getSlots() / 2) {
                    this.stackHandler.setStackDirectly(i, new ItemStackType());
                    continue;
                }
                this.stackHandler.setStackDirectly(i, new FluidStackType());
            }
        }
    }

    public void transferFromNet() {
        DimensionsNet net = this.getNet();
        if (net != null) {
            for (int i = 0; i < 9; ++i) {
                IStackType remaining;
                IStackType stack;
                IStackType current;
                IStackType flag = this.fakeStackHandler.getStackBySlot(i);
                if (flag == null || flag.isEmpty() || (current = this.stackHandler.getStorage().get(i)) != null && !current.isEmpty() && (current.getVanillaMaxStackSize() >= current.getStackAmount() || !current.isSameTypeSameComponents(flag.copy())) || (stack = net.getUnifiedStorage().extract(flag.copyWithCount(flag.getVanillaMaxStackSize()), false)) == null || stack.isEmpty() || (remaining = this.stackHandler.insert(i, stack.copy(), false)).getStackAmount() >= stack.getStackAmount()) continue;
                net.getUnifiedStorage().insert(remaining.copy(), false);
            }
        }
    }

    public void popStack() {
        this.handlerCache.forEach((typeId, handler) -> {
            Function<?, IStackHandlerWrapper<?>> handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId);
            IStackHandlerWrapper<?> stackHandlerWrapper = handlerGetter.apply(handler);
            block0: for (int i = 0; i < 9; ++i) {
                if (!this.fakeStackHandler.getStackBySlot(i).getTypeId().equals(typeId) || !this.fakeStackHandler.getStackBySlot(i).isSameTypeSameComponents(this.stackHandler.getStackBySlot(i))) continue;
                IStackType current = this.stackHandler.getStackBySlot(i).copy();
                for (int slot = 0; slot < stackHandlerWrapper.getSlots(); ++slot) {
                    long remainging = stackHandlerWrapper.insert(EnumFacing.NORTH, slot, current.copyStack(), false);
                    long extract = current.getStackAmount() - remainging;
                    this.stackHandler.extract(i, extract, false);
                    current.shrink(extract);
                    if (current.isEmpty()) continue block0;
                }
            }
        });
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stackHandler.deserializeNBT(compound.func_74775_l("inventory"));
        this.fakeStackHandler.deserializeNBT(compound.func_74775_l("flags"));
        this.popMode = compound.func_74767_n("popMode");
        this.setNeedsCapabilityUpdate();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inventory", (NBTBase)this.stackHandler.serializeNBT());
        compound.func_74782_a("flags", (NBTBase)this.fakeStackHandler.serializeNBT());
        compound.func_74757_a("popMode", this.popMode);
        return compound;
    }
}

