/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Handler;

import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.ChemicalStackType;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import net.minecraft.util.EnumFacing;

public class ChemicalStackTypedHandler
implements IGasHandler {
    private StackTypedHandler handlerStorage;

    public ChemicalStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public GasTankInfo[] getTankInfo() {
        List<Integer> slots = this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID);
        if (slots != null) {
            GasTankInfo[] TankProperties2 = new GasTankInfo[slots.size()];
            for (int i = 0; i < slots.size(); ++i) {
                TankProperties2[i] = new GasTankInfoWarrper(i, this);
            }
            return TankProperties2;
        }
        return new GasTankInfo[0];
    }

    public int receiveGas(EnumFacing enumFacing, GasStack stack, boolean doAction) {
        boolean sim;
        boolean bl = sim = !doAction;
        if (stack.amount <= 0) {
            return 0;
        }
        long remaining = this.handlerStorage.insert(new ChemicalStackType(stack.copy()), sim).getStackAmount();
        if (remaining > 0L) {
            return (int)((long)stack.amount - remaining);
        }
        return stack.amount;
    }

    public GasStack drawGas(EnumFacing enumFacing, int amount, boolean doAction) {
        boolean sim = !doAction;
        int actualIndex = this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID).get(0);
        return ((ChemicalStackType)this.handlerStorage.extract(this.handlerStorage.getStackBySlot(actualIndex).copyWithCount(amount), sim)).copyStack();
    }

    public boolean canReceiveGas(EnumFacing enumFacing, Gas gas) {
        return true;
    }

    public boolean canDrawGas(EnumFacing enumFacing, Gas gas) {
        return true;
    }

    public static class GasTankInfoWarrper
    implements GasTankInfo {
        int tank;
        ChemicalStackTypedHandler handler;

        public GasTankInfoWarrper(int tank, ChemicalStackTypedHandler handler) {
            this.tank = tank;
            this.handler = handler;
        }

        @Nullable
        public GasStack getGas() {
            List<Integer> slots = this.handler.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID);
            int actualIndex = -1;
            if (slots != null && 0 <= this.tank && this.tank < slots.size()) {
                actualIndex = slots.get(this.tank);
            }
            if (actualIndex != -1) {
                return (GasStack)this.handler.handlerStorage.getStackBySlot(actualIndex).getStack();
            }
            return new GasStack(GasRegistry.getGas((int)0), 0);
        }

        public int getStored() {
            return this.getGas().amount;
        }

        public int getMaxGas() {
            return 64000;
        }
    }
}

