/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Handler;

import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.FluidStackType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidStackTypedHandler
implements IFluidHandler {
    private StackTypedHandler handlerStorage;

    public FluidStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public IFluidTankProperties[] getTankProperties() {
        List<Integer> slots = this.handlerStorage.getTypeIdIndexList(FluidStackType.ID);
        if (slots != null) {
            IFluidTankProperties[] TankProperties2 = new IFluidTankProperties[slots.size()];
            for (int i = 0; i < slots.size(); ++i) {
                TankProperties2[i] = new TankProperties(i, this);
            }
            return TankProperties2;
        }
        return new IFluidTankProperties[0];
    }

    public int fill(FluidStack fluidStack, boolean doAction) {
        boolean sim;
        boolean bl = sim = !doAction;
        if (fluidStack.amount <= 0) {
            return 0;
        }
        int allAmount = fluidStack.amount;
        int remaining = (int)this.handlerStorage.insert(new FluidStackType(fluidStack.copy()), sim).getStackAmount();
        return allAmount - remaining;
    }

    public FluidStack drain(FluidStack fluidStack, boolean doAction) {
        boolean sim = !doAction;
        return ((FluidStackType)this.handlerStorage.extract(new FluidStackType(fluidStack.copy()), sim)).copyStack();
    }

    public FluidStack drain(int count, boolean doAction) {
        boolean sim = !doAction;
        int actualIndex = this.handlerStorage.getTypeIdIndexList(FluidStackType.ID).get(0);
        return ((FluidStackType)this.handlerStorage.extract(this.handlerStorage.getStackBySlot(actualIndex).copy(), sim)).copyStack();
    }

    public static class TankProperties
    implements IFluidTankProperties {
        int tank;
        FluidStackTypedHandler handler;

        public TankProperties(int tank, FluidStackTypedHandler handler) {
            this.tank = tank;
            this.handler = handler;
        }

        @Nullable
        public FluidStack getContents() {
            List<Integer> slots = this.handler.handlerStorage.getTypeIdIndexList(FluidStackType.ID);
            int actualIndex = -1;
            if (slots != null && 0 <= this.tank && this.tank < slots.size()) {
                actualIndex = slots.get(this.tank);
            }
            if (actualIndex != -1) {
                return (FluidStack)this.handler.handlerStorage.getStackBySlot(actualIndex).getStack();
            }
            return new FluidStack(FluidRegistry.WATER, 0);
        }

        public int getCapacity() {
            return 64000;
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return true;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return true;
        }
    }
}

