/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Handler;

import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemStackTypedHandler
implements IItemHandler {
    private StackTypedHandler handlerStorage;

    public ItemStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getSlots() {
        List<Integer> slots = this.handlerStorage.getTypeIdIndexList(ItemStackType.ID);
        if (slots != null) {
            return slots.size();
        }
        return 0;
    }

    public ItemStack getStackInSlot(int slot) {
        List<Integer> slots = this.handlerStorage.getTypeIdIndexList(ItemStackType.ID);
        int actualIndex = -1;
        if (slots != null && 0 <= slot && slot < slots.size()) {
            actualIndex = slots.get(slot);
        }
        if (actualIndex != -1) {
            return (ItemStack)this.handlerStorage.getStackBySlot(actualIndex).getStack();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack itemStack, boolean sim) {
        int actualIndex = this.handlerStorage.getTypeIdIndexList(ItemStackType.ID).get(slot);
        ItemStackType remaining = (ItemStackType)this.handlerStorage.insert(actualIndex, new ItemStackType(itemStack.func_77946_l()), sim);
        return remaining.copyStack();
    }

    public ItemStack extractItem(int slot, int count, boolean sim) {
        int actualIndex = this.handlerStorage.getTypeIdIndexList(ItemStackType.ID).get(slot);
        ItemStackType extracts = (ItemStackType)this.handlerStorage.extract(actualIndex, count, sim);
        return extracts.copyStack();
    }

    public int getSlotLimit(int slot) {
        int actualIndex = this.handlerStorage.getTypeIdIndexList(ItemStackType.ID).get(slot);
        ItemStackType stackType = (ItemStackType)this.handlerStorage.getStackBySlot(actualIndex);
        if (!stackType.isEmpty()) {
            return (int)stackType.getVanillaMaxStackSize();
        }
        return 99;
    }

    public boolean isItemValid(int slot, ItemStack itemStack) {
        return true;
    }
}

