/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Stack;

import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChemicalStackType
implements IStackType<GasStack> {
    public static final ResourceLocation ID = new ResourceLocation("beyonddimensions", "stack_type/chemical");
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    private GasStack stack;

    public ChemicalStackType() {
        this.stack = new GasStack(GasRegistry.getGas((int)0), 0);
    }

    public ChemicalStackType(GasStack stack) {
        this.stack = stack;
    }

    @Override
    public IStackType<GasStack> fromObject(Object key, long amount, int meta, NBTTagCompound dataComponentPatch) {
        Object object = key;
        if (object instanceof Gas) {
            Gas chemical = (Gas)object;
            GasStack chemicalStack = new GasStack(chemical, (int)amount);
            return new ChemicalStackType(chemicalStack);
        }
        return null;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public IStackType<GasStack> getEmpty() {
        return new ChemicalStackType();
    }

    @Override
    public GasStack getStack() {
        return this.stack;
    }

    @Override
    public void setStack(GasStack stack) {
        this.stack = stack.copy();
    }

    @Override
    public Class<GasStack> getStackClass() {
        return GasStack.class;
    }

    @Override
    public Class<?> getSourceClass() {
        return Gas.class;
    }

    @Override
    public Object getSource() {
        return GasRegistry.getGas((int)0);
    }

    @Override
    public boolean isEmpty() {
        return this.stack.amount <= 0 || this.stack.getGas() == null;
    }

    @Override
    public GasStack getEmptyStack() {
        return new GasStack(GasRegistry.getGas((int)0), 0);
    }

    @Override
    public GasStack copyStack() {
        return this.stack.copy();
    }

    @Override
    public GasStack copyStackWithCount(long count) {
        return new GasStack(this.stack.getGas(), (int)count);
    }

    @Override
    public IStackType<GasStack> copy() {
        return new ChemicalStackType(this.stack.copy());
    }

    @Override
    public IStackType<GasStack> copyWithCount(long count) {
        return new ChemicalStackType(new GasStack(this.stack.getGas(), (int)count));
    }

    @Override
    public long getStackAmount() {
        return this.stack.amount;
    }

    @Override
    public void setStackAmount(long amount) {
        this.stack.amount = (int)amount;
    }

    @Override
    public void grow(long amount) {
        this.setStackAmount(this.getStackAmount() + amount);
    }

    @Override
    public void shrink(long amount) {
        this.grow(-amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return 64000L;
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public GasStack splitStack(long amount) {
        if (amount <= 0L) {
            return this.getEmptyStack();
        }
        long splitAmount = Math.min(amount, (long)this.stack.amount);
        GasStack split = this.stack.copy();
        split.amount = (int)splitAmount;
        this.stack.amount -= (int)splitAmount;
        return split;
    }

    @Override
    public IStackType<GasStack> split(long amount) {
        if (amount <= 0L) {
            return new ChemicalStackType();
        }
        long splitAmount = Math.min(amount, (long)this.stack.amount);
        GasStack split = this.stack.copy();
        split.amount = (int)splitAmount;
        this.stack.amount -= (int)splitAmount;
        return new ChemicalStackType(split);
    }

    @Override
    public boolean isSame(IStackType<GasStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return this.stack.isGasEqual(other.getStack());
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<GasStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return this.stack.isGasEqual(other.getStack());
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.func_192572_a(this.getTypeId());
        boolean hasItem = !this.isEmpty();
        buf.writeBoolean(hasItem);
        if (hasItem) {
            buf.func_179254_b((long)this.stack.amount);
            GasStack copy = new GasStack(this.stack.getGas(), 1);
            NBTTagCompound tag = copy.write(new NBTTagCompound());
            buf.func_150786_a(tag);
        }
    }

    @Override
    public IStackType<GasStack> deserialize(PacketBuffer buf, ResourceLocation typeId) {
        NBTTagCompound stackNBT;
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        boolean hasItem = buf.readBoolean();
        if (!hasItem) {
            return new ChemicalStackType(this.getEmptyStack());
        }
        long count = buf.func_179260_f();
        try {
            stackNBT = buf.func_150793_b();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        GasStack stack = GasStack.readFromNBT((NBTTagCompound)stackNBT);
        stack.amount = (int)count;
        return new ChemicalStackType(stack);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("Amount", this.getStackAmount());
        tag.func_74782_a("Stack", (NBTBase)new GasStack(this.stack.getGas(), 1).write(new NBTTagCompound()));
        return tag;
    }

    @Override
    public IStackType<GasStack> deserializeNBT(NBTTagCompound nbt) {
        ChemicalStackType stack = new ChemicalStackType(GasStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("Stack")));
        stack.setStackAmount(nbt.func_74763_f("Amount"));
        return stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(int x, int y) {
        GasStack gasStack = this.stack;
        if (gasStack == null && !this.isEmpty()) {
            return;
        }
        Gas gas = gasStack.getGas();
        TextureAtlasSprite sprite = gas.getSprite();
        int gasColor = gas.getTint();
        IngredientRenderer.drawTiledSprite(16, 16, gasColor, 16L, sprite, x, y);
        if (gasStack.amount > 0) {
            String countText = this.getCountText(gasStack.amount);
            float scale = 0.666f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            int X = (int)(((float)(x + -2) + 16.0f + 2.0f - (float)Minecraft.func_71410_x().field_71466_p.func_78256_a(countText) * 0.666f) * 1.0f / 0.666f);
            int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
            Minecraft.func_71410_x().field_71466_p.func_175065_a(countText, (float)X, (float)Y, 0xFFFFFF, true);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public String getCountText(long count) {
        if (count <= 0L) {
            return "";
        }
        return StringFormat.formatCount(count);
    }

    @Override
    public String getDisplayName() {
        return this.stack.getGas().getLocalizedName();
    }

    @Override
    public List<String> getTooltipLines(@Nullable EntityPlayer player, ITooltipFlag tooltipFlag) {
        String id;
        if (this.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> tooltips = new ArrayList<String>();
        Gas chemical = this.stack.getGas();
        String displayName = this.getDisplayName();
        tooltips.add(displayName);
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x && (id = chemical.getName()) != null) {
            tooltips.add(TextFormatting.DARK_GRAY + id);
        }
        tooltips.add(TextFormatting.BLUE.toString() + TextFormatting.ITALIC + "Mekanism");
        tooltips.add(I18n.func_135052_a((String)"stack.beyonddimensions.stored.mb", (Object[])new Object[]{this.stack.amount}));
        return tooltips;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTooltip(int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        List<String> tooltip = this.getTooltipLines((EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        GuiUtils.drawHoveringText(tooltip, (int)mouseX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)mc.field_71466_p);
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof ChemicalStackType) {
            ChemicalStackType otherStack = (ChemicalStackType)object;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.stack.hashCode();
        return code;
    }
}

