/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Storage;

import com.wintercogs.beyonddimensions.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidUnifiedStorageHandler
implements IFluidHandler {
    private UnifiedStorage storage;

    public FluidUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public IFluidTankProperties[] getTankProperties() {
        List<Integer> slots = this.storage.getTypeIdIndexList(FluidStackType.ID);
        if (slots != null) {
            IFluidTankProperties[] TankProperties2 = new IFluidTankProperties[slots.size()];
            for (int i = 0; i < slots.size(); ++i) {
                TankProperties2[i] = new TankProperties(i, this);
            }
            return TankProperties2;
        }
        return new IFluidTankProperties[0];
    }

    public int fill(FluidStack fluidStack, boolean doAction) {
        boolean sim;
        boolean bl = sim = !doAction;
        if (fluidStack.amount <= 0) {
            return 0;
        }
        int allAmount = fluidStack.amount;
        int remaining = (int)this.storage.insert(new FluidStackType(fluidStack.copy()), sim).getStackAmount();
        return allAmount - remaining;
    }

    public FluidStack drain(FluidStack fluidStack, boolean doAction) {
        boolean sim = !doAction;
        return ((FluidStackType)this.storage.extract(new FluidStackType(fluidStack.copy()), sim)).copyStack();
    }

    public FluidStack drain(int count, boolean doAction) {
        boolean sim = !doAction;
        int actualIndex = this.storage.getTypeIdIndexList(FluidStackType.ID).get(0);
        return ((FluidStackType)this.storage.extract(this.storage.getStackBySlot(actualIndex).copy(), sim)).copyStack();
    }

    public static class TankProperties
    implements IFluidTankProperties {
        int tank;
        FluidUnifiedStorageHandler handler;

        public TankProperties(int tank, FluidUnifiedStorageHandler handler) {
            this.tank = tank;
            this.handler = handler;
        }

        @Nullable
        public FluidStack getContents() {
            List<Integer> slots = this.handler.storage.getTypeIdIndexList(FluidStackType.ID);
            int actualIndex = -1;
            if (slots != null && 0 <= this.tank && this.tank < slots.size()) {
                actualIndex = slots.get(this.tank);
            }
            if (actualIndex != -1) {
                return (FluidStack)this.handler.storage.getStackBySlot(actualIndex).getStack();
            }
            return new FluidStack(FluidRegistry.WATER, 0);
        }

        public int getCapacity() {
            return Integer.MAX_VALUE;
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return true;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return true;
        }
    }
}

