/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Storage;

import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.Registry.StackTypeRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public class UnifiedStorage
implements IStackTypedHandler {
    private DimensionsNet net;
    private final ArrayList<IStackType> storage = new ArrayList();
    private final Map<ResourceLocation, List<Integer>> typeIdIndex = new HashMap<ResourceLocation, List<Integer>>();
    public static final Map<ResourceLocation, Function<UnifiedStorage, Object>> typedHandlerMap = new HashMap<ResourceLocation, Function<UnifiedStorage, Object>>();

    public UnifiedStorage(DimensionsNet net) {
        this.net = net;
    }

    @Override
    public void onChange() {
        this.net.func_76186_a(true);
    }

    @Override
    public Object getTypedHandler(ResourceLocation typeId) {
        return typedHandlerMap.get(typeId).apply(this);
    }

    @Override
    public int getSlots() {
        return this.storage.size();
    }

    @Override
    public IStackType getStackBySlot(int slot) {
        return IStackTypedHandler.super.getStackBySlot(slot);
    }

    @Override
    public List<IStackType> getStorage() {
        return Collections.unmodifiableList(this.storage);
    }

    @Override
    public void clearStorage() {
        this.storage.clear();
        this.typeIdIndex.clear();
        this.onChange();
    }

    @Override
    public boolean hasStackType(IStackType other) {
        return this.getStackByStack(other) != null;
    }

    @Override
    public void setStackDirectly(int slot, IStackType stack) {
        ResourceLocation newTypeId = stack.getTypeId();
        ResourceLocation oldTypeId = this.getStorage().get(slot).getTypeId();
        this.storage.set(slot, stack.copy());
        this.typeIdIndex.computeIfAbsent(oldTypeId, k -> new ArrayList()).remove((Object)slot);
        this.typeIdIndex.computeIfAbsent(newTypeId, k -> new ArrayList()).add(slot);
        this.onChange();
    }

    @Override
    public void addStackToIndexDirectly(int slot, IStackType stack) {
        ResourceLocation newTypeId = stack.getTypeId();
        this.storage.add(slot, stack.copy());
        this.typeIdIndex.computeIfAbsent(newTypeId, k -> new ArrayList()).add(slot);
        this.onChange();
    }

    @Override
    public void addStackDirectly(IStackType stack) {
        ResourceLocation newTypeId = stack.getTypeId();
        int slot = this.storage.size();
        this.storage.add(stack.copy());
        this.typeIdIndex.computeIfAbsent(newTypeId, k -> new ArrayList()).add(slot);
        this.onChange();
    }

    @Override
    public IStackType getStackByStack(IStackType stackType) {
        ResourceLocation typeId = stackType.getTypeId();
        List<Integer> indices = this.typeIdIndex.get(typeId);
        if (indices != null) {
            for (Integer index : indices) {
                IStackType existing = this.storage.get(index);
                if (!existing.isSameTypeSameComponents(stackType)) continue;
                return existing;
            }
        }
        return null;
    }

    @Override
    public long getSlotCapacity(int slot) {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean isStackValid(int slot, IStackType stack) {
        return true;
    }

    @Override
    public IStackType insert(int slot, IStackType stack, boolean simulate) {
        return this.insert(stack, simulate);
    }

    @Override
    public IStackType insert(IStackType stack, boolean simulate) {
        if (stack.isEmpty()) {
            return StackCreater.CreateEmpty(stack.getTypeId());
        }
        long remaining = stack.getStackAmount();
        long canInsert = Math.min(this.getSlotCapacity(0), stack.getCustomMaxStackSize());
        ResourceLocation typeId = stack.getTypeId();
        List<Integer> indices = this.typeIdIndex.get(typeId);
        if (indices != null) {
            for (Integer index : indices) {
                IStackType existing = this.storage.get(index);
                if (!existing.isSameTypeSameComponents(stack)) continue;
                long actualInsert = Math.min(remaining, canInsert -= existing.getStackAmount());
                remaining -= actualInsert;
                if (!simulate) {
                    existing.grow(actualInsert);
                    this.onChange();
                }
                return stack.copyWithCount(remaining);
            }
        }
        long actualInsert = Math.min(remaining, canInsert);
        remaining -= actualInsert;
        if (!simulate) {
            IStackType newStack = stack.copyWithCount(actualInsert);
            this.storage.add(newStack);
            int newIndex = this.storage.size() - 1;
            this.typeIdIndex.computeIfAbsent(typeId, k -> new ArrayList()).add(newIndex);
            this.onChange();
        }
        return stack.copyWithCount(remaining);
    }

    @Override
    public IStackType extract(IStackType stack, boolean simulate) {
        if (stack.isEmpty()) {
            return stack.getEmpty();
        }
        ResourceLocation typeId = stack.getTypeId();
        List<Integer> indices = this.typeIdIndex.get(typeId);
        if (indices != null) {
            for (int i = 0; i < indices.size(); ++i) {
                int storageIndex = indices.get(i);
                IStackType existing = this.storage.get(storageIndex);
                if (!existing.isSameTypeSameComponents(stack)) continue;
                long extracted = Math.min(stack.getStackAmount(), existing.getStackAmount());
                IStackType sim = existing.copy();
                IStackType result = sim.split(extracted);
                if (!simulate) {
                    existing.shrink(extracted);
                    if (existing.getStackAmount() <= 0L) {
                        this.storage.remove(storageIndex);
                        indices.remove(i);
                        this.updateIndicesAfterRemoval(storageIndex);
                        if (indices.isEmpty()) {
                            this.typeIdIndex.remove(typeId);
                        }
                    }
                    this.onChange();
                }
                return result;
            }
        }
        return stack.getEmpty();
    }

    private void updateIndicesAfterRemoval(int removedIndex) {
        for (List<Integer> indexList : this.typeIdIndex.values()) {
            for (int i = 0; i < indexList.size(); ++i) {
                int currentIndex = indexList.get(i);
                if (currentIndex <= removedIndex) continue;
                indexList.set(i, currentIndex - 1);
            }
        }
    }

    public void rebuildAllIndices() {
        this.typeIdIndex.clear();
        for (int i = 0; i < this.storage.size(); ++i) {
            IStackType stack = this.storage.get(i);
            if (stack == null || stack.isEmpty()) continue;
            ResourceLocation typeId = stack.getTypeId();
            this.typeIdIndex.computeIfAbsent(typeId, k -> new ArrayList()).add(i);
        }
    }

    @Override
    public IStackType extract(int slot, long amount, boolean simulate) {
        if (slot < 0 || slot >= this.storage.size()) {
            return null;
        }
        IStackType existing = this.storage.get(slot);
        if (existing.isEmpty()) {
            return existing.getEmpty();
        }
        long extracted = Math.min(amount, existing.getStackAmount());
        IStackType sim = existing.copy();
        IStackType result = sim.split(extracted);
        if (!simulate) {
            existing.shrink(extracted);
            if (existing.getStackAmount() <= 0L) {
                ResourceLocation typeId = existing.getTypeId();
                this.storage.remove(slot);
                List<Integer> indices = this.typeIdIndex.get(typeId);
                if (indices != null) {
                    indices.remove((Object)slot);
                    if (indices.isEmpty()) {
                        this.typeIdIndex.remove(typeId);
                    }
                }
                this.updateIndicesAfterRemoval(slot);
                this.onChange();
            }
        }
        return result;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList stacksTag = new NBTTagList();
        for (IStackType stack : this.storage) {
            if (stack.isEmpty()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74782_a("TypedStack", (NBTBase)stack.serializeNBT());
            stackTag.func_74778_a("Type", stack.getTypeId().toString());
            stacksTag.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Stacks", (NBTBase)stacksTag);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.storage.clear();
        this.typeIdIndex.clear();
        NBTTagList stacksTag = tag.func_150295_c("Stacks", 10);
        for (NBTBase t : stacksTag) {
            NBTTagCompound stackTag = (NBTTagCompound)t;
            ResourceLocation typeId = new ResourceLocation(stackTag.func_74779_i("Type"));
            IStackType stackEmpty = StackTypeRegistry.getType(typeId).copy();
            IStackType stackActual = stackEmpty.deserializeNBT(stackTag.func_74775_l("TypedStack"));
            if (stackActual.isEmpty()) continue;
            this.storage.add(stackActual);
            this.typeIdIndex.computeIfAbsent(typeId, k -> new ArrayList()).add(this.storage.size() - 1);
        }
    }

    private int findExistingSlot(IStackType stack) {
        ResourceLocation typeId = stack.getTypeId();
        List<Integer> indices = this.typeIdIndex.get(typeId);
        if (indices != null) {
            for (Integer index : indices) {
                IStackType existing = this.storage.get(index);
                if (!existing.isSameTypeSameComponents(stack)) continue;
                return index;
            }
        }
        return -1;
    }

    public Map<ResourceLocation, List<Integer>> getTypeIdIndexMap() {
        return this.typeIdIndex;
    }

    public List<Integer> getTypeIdIndexList(ResourceLocation typeId) {
        return this.typeIdIndex.get(typeId);
    }
}

