/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Gui;

import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.ChemicalStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Gui.BDBaseGUI;
import com.wintercogs.beyonddimensions.Unit.CapabilityHelper;
import com.wintercogs.beyonddimensions.Unit.StackHandlerWrapperHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mekanism.api.gas.GasStack;
import mekanism.common.item.ItemBlockGasTank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public abstract class BDOrderedContainerGUI
extends BDBaseGUI {
    @Override
    protected void quickMoveHandle(int slotIndex, IStackType clickStack, int button, boolean isFakeSlot, EntityPlayer player, IStackTypedHandler storage) {
        ItemStackType clickedItem;
        if (!clickStack.isEmpty() && clickStack instanceof ItemStackType && (clickedItem = (ItemStackType)storage.getStackBySlot(slotIndex)) != null && !clickedItem.isEmpty()) {
            long maxMoveCount = Math.min(clickedItem.getStackAmount(), clickedItem.getVanillaMaxStackSize());
            if (button == 1) {
                maxMoveCount /= 2L;
            }
            ItemStack moveIn = clickedItem.copyStackWithCount(maxMoveCount);
            player.field_71071_by.func_70441_a(moveIn);
            int remaining = moveIn.func_190916_E();
            int needToRemove = (int)(maxMoveCount - (long)remaining);
            if (needToRemove > 0) {
                storage.extract(slotIndex, needToRemove, false);
            }
        }
    }

    @Override
    protected void clickHandle(int slotIndex, IStackType clickStack, int button, boolean isFakeSlot, EntityPlayer player, IStackTypedHandler storage) {
        ItemStack carriedItem = this.guiSyncManager.getCursorItem();
        if (clickStack.isEmpty()) {
            if (!carriedItem.func_190926_b()) {
                int changedCount = button == 0 ? carriedItem.func_190916_E() : 1;
                int remaining = (int)storage.insert(slotIndex, StackCreater.Create(ItemStackType.ID, carriedItem.func_77946_l(), changedCount), false).getStackAmount();
                int needRemove = changedCount - remaining;
                int newCount = carriedItem.func_190916_E() - needRemove;
                if (newCount <= 0) {
                    this.guiSyncManager.setCursorItem(ItemStack.field_190927_a);
                } else {
                    ItemStack newCarriedItem = carriedItem.func_77946_l();
                    newCarriedItem.func_190920_e(newCount);
                    this.guiSyncManager.setCursorItem(newCarriedItem);
                }
            }
        } else {
            IStackType remaining = clickStack;
            if (remaining instanceof ItemStackType) {
                ItemStackType clickItem = (ItemStackType)remaining;
                if (carriedItem.func_190926_b()) {
                    int woundChangeNum = (int)Math.min(clickItem.getStackAmount(), clickItem.getVanillaMaxStackSize());
                    int actualChangeNum = button == 0 ? woundChangeNum : (woundChangeNum + 1) / 2;
                    ItemStack takenItem = ((ItemStack)storage.extract(slotIndex, actualChangeNum, false).getStack()).func_77946_l();
                    if (takenItem != null) {
                        this.guiSyncManager.setCursorItem(takenItem);
                        storage.onChange();
                    }
                } else {
                    int changedCount = button == 0 ? carriedItem.func_190916_E() : 1;
                    int remaining2 = (int)storage.insert(slotIndex, StackCreater.Create(ItemStackType.ID, carriedItem, changedCount), false).getStackAmount();
                    int needRemove = changedCount - remaining2;
                    int newCount = carriedItem.func_190916_E() - needRemove;
                    if (newCount <= 0) {
                        this.guiSyncManager.setCursorItem(ItemStack.field_190927_a);
                    } else {
                        ItemStack newCarriedItem = carriedItem.func_77946_l();
                        newCarriedItem.func_190920_e(newCount);
                        this.guiSyncManager.setCursorItem(newCarriedItem);
                    }
                }
            }
        }
    }

    @Override
    protected void quickMoveHandleInventory(int slotIndex, IStackType clickStack, int button, boolean isFakeSlot, EntityPlayer player, IStackTypedHandler storage) {
        ItemStackType clickedItem;
        if (storage == null) {
            return;
        }
        if (!clickStack.isEmpty() && clickStack instanceof ItemStackType && (clickedItem = new ItemStackType(this.guiSyncManager.getPlayerInventory().getStackInSlot(slotIndex))) != null && !clickedItem.isEmpty()) {
            IStackType<ItemStack> moveIn;
            IStackType remainStack;
            int needToRemove;
            long maxMoveCount = Math.min(clickedItem.getStackAmount(), clickedItem.getVanillaMaxStackSize());
            if (button == 1) {
                maxMoveCount /= 2L;
            }
            if ((needToRemove = (int)(maxMoveCount - (remainStack = storage.insert(moveIn = clickedItem.copyWithCount(maxMoveCount), false)).getStackAmount())) > 0) {
                this.guiSyncManager.getPlayerInventory().extractItem(slotIndex, needToRemove, false);
            }
        }
    }

    @Override
    protected void FakeClickHandle(int slotIndex, IStackType clickStack, int button, boolean isFakeSlot, EntityPlayer player, IStackTypedHandler storage) {
        ItemStack carriedItem = this.guiSyncManager.getCursorItem();
        if (clickStack.isEmpty()) {
            if (!carriedItem.func_190926_b()) {
                if (button == 0) {
                    ItemStack copy = carriedItem.func_77946_l();
                    copy.func_190920_e(1);
                    storage.insert(slotIndex, new ItemStackType(copy), false);
                } else if (button == 1) {
                    Item item;
                    CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                        IStackType<?> stack;
                        Function<?, IStackHandlerWrapper<?>> handlerGetter;
                        IStackHandlerWrapper<?> stackHandlerWrapper;
                        Object handler = carriedItem.getCapability(cap, EnumFacing.DOWN);
                        if (handler != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0 && (stack = StackCreater.Create(typeId, stackHandlerWrapper.getStackInSlot(0), 1L)) != null && !stack.isEmpty()) {
                            storage.insert(slotIndex, stack, false);
                        }
                    });
                    if (BeyondDimensions.MekLoaded && (item = carriedItem.func_77973_b()) instanceof ItemBlockGasTank) {
                        ChemicalStackType stackTyped;
                        ItemBlockGasTank tank = (ItemBlockGasTank)item;
                        NBTTagCompound gasTag = carriedItem.func_77978_p().func_74775_l("mekData").func_74775_l("stored");
                        GasStack gasStack = GasStack.readFromNBT((NBTTagCompound)gasTag);
                        if (gasStack != null && !(stackTyped = new ChemicalStackType(gasStack)).isEmpty()) {
                            stackTyped.setStackAmount(1L);
                            storage.insert(slotIndex, stackTyped, false);
                        }
                    }
                }
            }
        } else if (carriedItem.func_190926_b()) {
            storage.extract(slotIndex, clickStack.getStackAmount(), false);
        } else {
            storage.extract(slotIndex, clickStack.getStackAmount(), false);
        }
    }

    @Override
    public List<Integer> buildStorageWithCurrentState(ArrayList<IStackType> storage) {
        ArrayList<Integer> cacheIndex = new ArrayList<Integer>();
        for (int i = 0; i < storage.size(); ++i) {
            cacheIndex.add(i);
        }
        return cacheIndex;
    }

    @Override
    public void updateViewerStorage() {
        for (IStackType stack : this.viewerStackTypedHandler.getStorage()) {
            stack.setStackAmount(-1L);
        }
        int index = 0;
        for (IStackType stack : this.stackTypedHandler.getStorage()) {
            this.viewerStackTypedHandler.insert(index, stack.copy(), false);
            ++index;
        }
        this.buildIndexList(new ArrayList<IStackType>(this.viewerStackTypedHandler.getStorage()));
    }
}

