/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Gui.Sync;

import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.network.PacketBuffer;

public class UnorderdStackTypedHandlerSync
extends ValueSyncHandler<IStackTypedHandler> {
    private IStackTypedHandler stacks;
    private List<IStackType> lastStacks;

    public UnorderdStackTypedHandlerSync(IStackTypedHandler stacks) {
        this.stacks = stacks;
        this.lastStacks = new ArrayList<IStackType>();
    }

    public void setValue(IStackTypedHandler StackTypeList, boolean setSource, boolean sync) {
        this.stacks = StackTypeList;
        if (setSource) {
            // empty if block
        }
        if (sync && !NetworkUtils.isClient()) {
            this.syncToClient(0, this::write);
        }
        this.onValueChanged();
    }

    public IStackTypedHandler getValue() {
        return this.stacks;
    }

    public boolean updateCacheFromSource(boolean init) {
        if (!NetworkUtils.isClient()) {
            this.syncToClient(0, this::write);
        }
        return true;
    }

    public void write(PacketBuffer packetBuffer) throws IOException {
        ArrayList changedItem = new ArrayList();
        ArrayList<Long> changedCount = new ArrayList<Long>();
        ArrayList cacheLast = new ArrayList();
        for (IStackType iStackType : this.lastStacks) {
            cacheLast.add(iStackType.copy());
        }
        ArrayList cacheNow = new ArrayList();
        for (IStackType iStackType : this.stacks.getStorage()) {
            cacheNow.add(iStackType.copy());
        }
        this.refreshLast();
        HashMap<IStackType, Long> hashMap = new HashMap<IStackType, Long>();
        for (IStackType iStackType : cacheLast) {
            hashMap.put(iStackType, hashMap.getOrDefault(iStackType, 0L) + iStackType.getStackAmount());
        }
        HashMap<IStackType, Long> hashMap2 = new HashMap<IStackType, Long>();
        for (IStackType iStackType : cacheNow) {
            hashMap2.put(iStackType, hashMap2.getOrDefault(iStackType, 0L) + iStackType.getStackAmount());
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(hashMap.keySet());
        hashSet.addAll(hashMap2.keySet());
        for (IStackType key : hashSet) {
            long lastCount = hashMap.getOrDefault(key, 0L);
            long nowCount = hashMap2.getOrDefault(key, 0L);
            long delta = nowCount - lastCount;
            if (delta == 0L) continue;
            changedItem.add(key.copy());
            changedCount.add(delta);
        }
        int n = changedItem.size();
        packetBuffer.func_150787_b(n);
        for (int i = 0; i < n; ++i) {
            ((IStackType)changedItem.get(i)).serialize(packetBuffer);
            packetBuffer.func_179254_b(((Long)changedCount.get(i)).longValue());
        }
    }

    public void read(PacketBuffer packetBuffer) throws IOException {
        if (!NetworkUtils.isClient()) {
            return;
        }
        int changes = packetBuffer.func_150792_a();
        ArrayList<IStackType> changedItem = new ArrayList<IStackType>(changes);
        ArrayList<Long> changedCount = new ArrayList<Long>(changes);
        for (int i = 0; i < changes; ++i) {
            changedItem.add(IStackType.deserializeCommon(packetBuffer));
            changedCount.add(packetBuffer.func_179260_f());
        }
        IStackTypedHandler clientStorage = this.stacks;
        int i = 0;
        for (IStackType remoteStack : changedItem) {
            if (clientStorage.hasStackType(remoteStack)) {
                if ((Long)changedCount.get(i) > 0L) {
                    clientStorage.insert(remoteStack.copyWithCount((Long)changedCount.get(i)), false);
                } else {
                    clientStorage.extract(remoteStack.copyWithCount(-((Long)changedCount.get(i)).longValue()), false);
                }
            } else if ((Long)changedCount.get(i) > 0L) {
                clientStorage.insert(remoteStack.copyWithCount((Long)changedCount.get(i)), false);
            }
            ++i;
        }
        this.onValueChanged();
    }

    public void refreshLast() {
        this.lastStacks.clear();
        for (IStackType stack : this.stacks.getStorage()) {
            this.lastStacks.add(stack.copy());
        }
    }
}

