/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetInterfaceBlockEntity;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Menu.BDOrderedContainerMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Network.Packet.ClientOrServer.PopModeButtonPacket;
import com.wintercogs.beyonddimensions.Network.Packet.toClient.SyncFlagPacket;
import com.wintercogs.beyonddimensions.Network.Packet.toClient.SyncStoragePacket;
import com.wintercogs.beyonddimensions.Registry.PacketRegister;
import com.wintercogs.beyonddimensions.Registry.UIRegister;
import com.wintercogs.beyonddimensions.Unit.CapabilityHelper;
import com.wintercogs.beyonddimensions.Unit.StackHandlerWrapperHelper;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NetInterfaceBaseMenu
extends BDOrderedContainerMenu {
    public StackTypedHandler viewerStorage = new StackTypedHandler(9);
    private ArrayList<IStackType> lastStorage;
    public final StackTypedHandler flagStorage;
    public StackTypedHandler viewerFlagStorage;
    public ArrayList<IStackType> lastFlagStorage;
    public boolean popMode = false;
    public NetInterfaceBlockEntity be;

    public NetInterfaceBaseMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, new StackTypedHandler(9), new StackTypedHandler(9), null, new SimpleContainerData(0));
    }

    public NetInterfaceBaseMenu(int id, Inventory playerInventory, StackTypedHandler storage, StackTypedHandler flagStorage, NetInterfaceBlockEntity be, SimpleContainerData uselessContainer) {
        super(UIRegister.Net_Interface_Menu.get(), id, playerInventory, storage);
        int i;
        this.flagStorage = flagStorage;
        this.viewerFlagStorage = new StackTypedHandler(9);
        if (!this.player.m_9236_().m_5776_()) {
            this.lastStorage = new ArrayList();
            for (i = 0; i < this.storage.getStorage().size(); ++i) {
                this.lastStorage.add(new ItemStackType());
            }
            this.lastFlagStorage = new ArrayList();
            for (i = 0; i < this.flagStorage.getStorage().size(); ++i) {
                this.lastFlagStorage.add(new ItemStackType());
            }
            this.popMode = be.popMode;
            this.be = be;
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new StoredStackSlot(this.viewerStorage, i, 8 + i * 18, 71));
        }
        for (i = 0; i < flagStorage.getStorage().size(); ++i) {
            StoredStackSlot flagSlot = new StoredStackSlot(this.viewerFlagStorage, i, 8 + i * 18, 53);
            flagSlot.setFake(true);
            this.m_38897_(flagSlot);
        }
        this.inventoryStartIndex = this.f_38839_.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 123 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 181));
        }
        this.inventoryEndIndex = this.f_38839_.size();
    }

    @Override
    protected void updateChange() {
        this.updateStorage();
        this.updateFlag();
    }

    @Override
    protected void initUpdate() {
        PacketRegister.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new PopModeButtonPacket(this.popMode));
    }

    private void updateStorage() {
        ArrayList changedItems = new ArrayList();
        ArrayList<Long> changedCounts = new ArrayList<Long>();
        ArrayList<Integer> changedIndices = new ArrayList<Integer>();
        ArrayList<@Nullable IStackType<T>> lastSnapshot = new ArrayList();
        for (IStackType iStackType : this.lastStorage) {
            lastSnapshot.add(iStackType != null ? iStackType.copy() : null);
        }
        ArrayList<@Nullable IStackType<T>> currentSnapshot = new ArrayList();
        for (IStackType stack : this.storage.getStorage()) {
            currentSnapshot.add(stack != null ? stack.copy() : null);
        }
        int n = Math.max(lastSnapshot.size(), currentSnapshot.size());
        while (lastSnapshot.size() < n) {
            lastSnapshot.add(null);
        }
        while (currentSnapshot.size() < n) {
            currentSnapshot.add(null);
        }
        for (int slot = 0; slot < n; ++slot) {
            IStackType lastStack = (IStackType)lastSnapshot.get(slot);
            IStackType currentStack = (IStackType)currentSnapshot.get(slot);
            boolean stackChanged = false;
            if (lastStack == null != (currentStack == null)) {
                stackChanged = true;
            } else if (lastStack != null && currentStack != null && !lastStack.isSameTypeSameComponents(currentStack)) {
                stackChanged = true;
            }
            long delta = (currentStack != null ? currentStack.getStackAmount() : 0L) - (lastStack != null ? lastStack.getStackAmount() : 0L);
            if (delta != 0L) {
                stackChanged = true;
            }
            if (!stackChanged) continue;
            changedIndices.add(slot);
            changedItems.add(currentStack != null ? currentStack.copy() : null);
            changedCounts.add(delta);
        }
        if (!changedIndices.isEmpty()) {
            ArrayList<SyncStoragePacket> packets = new ArrayList<SyncStoragePacket>();
            int MAX_PACKET_SIZE = 921600;
            ArrayList<Integer> entrySizes = new ArrayList<Integer>(changedIndices.size());
            for (int i = 0; i < changedIndices.size(); ++i) {
                IStackType stack = (IStackType)changedItems.get(i);
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                if (stack != null) {
                    stack.serialize(buf);
                }
                int entrySize = 4 + buf.readableBytes() + 8;
                entrySizes.add(entrySize);
            }
            ArrayList<Integer> batchIndices = new ArrayList<Integer>();
            ArrayList<IStackType> batchItems = new ArrayList<IStackType>();
            ArrayList<Long> batchCounts = new ArrayList<Long>();
            int currentBatchSize = 0;
            for (int i = 0; i < changedIndices.size(); ++i) {
                int estimatedSize = (Integer)entrySizes.get(i);
                if (currentBatchSize + estimatedSize > 921600) {
                    packets.add(new SyncStoragePacket(new ArrayList<IStackType>(batchItems), new ArrayList<Long>(batchCounts), new ArrayList<Integer>(batchIndices)));
                    batchIndices.clear();
                    batchItems.clear();
                    batchCounts.clear();
                    currentBatchSize = 0;
                }
                batchIndices.add((Integer)changedIndices.get(i));
                batchItems.add((IStackType)changedItems.get(i));
                batchCounts.add((Long)changedCounts.get(i));
                currentBatchSize += estimatedSize;
            }
            if (!batchIndices.isEmpty()) {
                packets.add(new SyncStoragePacket(batchItems, batchCounts, batchIndices));
            }
            for (SyncStoragePacket packet : packets) {
                PacketRegister.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)packet);
            }
        }
        this.lastStorage.clear();
        this.lastStorage.addAll(currentSnapshot);
    }

    private void updateFlag() {
        ArrayList changedFlags = new ArrayList();
        ArrayList<Integer> changedFlagIndices = new ArrayList<Integer>();
        ArrayList<@Nullable IStackType<T>> lastFlagSnapshot = new ArrayList();
        for (IStackType iStackType : this.lastFlagStorage) {
            lastFlagSnapshot.add(iStackType != null ? iStackType.copy() : null);
        }
        ArrayList<@Nullable IStackType<T>> currentFlagSnapshot = new ArrayList();
        for (IStackType stack : this.flagStorage.getStorage()) {
            currentFlagSnapshot.add(stack != null ? stack.copy() : null);
        }
        int n = Math.max(lastFlagSnapshot.size(), currentFlagSnapshot.size());
        while (lastFlagSnapshot.size() < n) {
            lastFlagSnapshot.add(null);
        }
        while (currentFlagSnapshot.size() < n) {
            currentFlagSnapshot.add(null);
        }
        for (int slot = 0; slot < n; ++slot) {
            IStackType lastStack = (IStackType)lastFlagSnapshot.get(slot);
            IStackType currentStack = (IStackType)currentFlagSnapshot.get(slot);
            boolean stackChanged = false;
            if (lastStack == null != (currentStack == null)) {
                stackChanged = true;
            } else if (lastStack != null && currentStack != null && !lastStack.isSameTypeSameComponents(currentStack)) {
                stackChanged = true;
            }
            if (!stackChanged) continue;
            changedFlagIndices.add(slot);
            changedFlags.add(currentStack != null ? currentStack.copy() : null);
        }
        if (!changedFlagIndices.isEmpty()) {
            ArrayList<SyncFlagPacket> packets = new ArrayList<SyncFlagPacket>();
            int MAX_PACKET_SIZE = 921600;
            ArrayList<Integer> entrySizes = new ArrayList<Integer>(changedFlagIndices.size());
            for (int i = 0; i < changedFlagIndices.size(); ++i) {
                IStackType stack = (IStackType)changedFlags.get(i);
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                if (stack != null) {
                    stack.serialize(buf);
                }
                entrySizes.add(buf.readableBytes() + 4);
            }
            ArrayList<Integer> batchIndices = new ArrayList<Integer>();
            ArrayList<IStackType> batchFlags = new ArrayList<IStackType>();
            int currentBatchSize = 0;
            for (int i = 0; i < changedFlagIndices.size(); ++i) {
                int estimatedSize = (Integer)entrySizes.get(i);
                if (currentBatchSize + estimatedSize > 921600) {
                    packets.add(new SyncFlagPacket(new ArrayList<IStackType>(batchFlags), new ArrayList<Integer>(batchIndices)));
                    batchIndices.clear();
                    batchFlags.clear();
                    currentBatchSize = 0;
                }
                batchIndices.add((Integer)changedFlagIndices.get(i));
                batchFlags.add((IStackType)changedFlags.get(i));
                currentBatchSize += estimatedSize;
            }
            if (!batchIndices.isEmpty()) {
                packets.add(new SyncFlagPacket(batchFlags, batchIndices));
            }
            for (SyncFlagPacket packet : packets) {
                PacketRegister.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)packet);
            }
        }
        this.lastFlagStorage.clear();
        this.lastFlagStorage.addAll(currentFlagSnapshot);
    }

    public void updateViewerStorage() {
        for (IStackType stack : this.viewerStorage.getStorage()) {
            stack.setStack(stack.getEmptyStack());
        }
        for (int i = 0; i < this.storage.getStorage().size(); ++i) {
            this.viewerStorage.insert(i, this.storage.getStackBySlot(i), false);
        }
        for (IStackType stack : this.viewerFlagStorage.getStorage()) {
            stack.setStack(stack.getEmptyStack());
        }
        for (int i = 0; i < this.flagStorage.getStorage().size(); ++i) {
            this.viewerFlagStorage.insert(i, this.flagStorage.getStackBySlot(i), false);
        }
    }

    @Override
    public boolean m_6875_(Player player) {
        return true;
    }

    public void setFlagSlot(int slotIndex, IStackType clickStack, IStackType flagStack) {
        StoredStackSlot slot = (StoredStackSlot)((Object)this.f_38839_.get(slotIndex));
        if (slot.isFake()) {
            if (flagStack.isEmpty() && this.m_142621_().m_41619_()) {
                this.flagStorage.setStackDirectly(slot.getSlotIndex(), new ItemStackType());
            } else {
                this.flagStorage.setStackDirectly(slot.getSlotIndex(), flagStack);
            }
            return;
        }
    }

    @Override
    protected void FakeClickHandle(int slotIndex, IStackType clickStack, int button, Player player, IStackTypedHandler storage) {
        ItemStack carriedItem = this.m_142621_().m_41777_();
        StoredStackSlot slot = (StoredStackSlot)((Object)this.f_38839_.get(slotIndex));
        if (clickStack.isEmpty()) {
            if (!carriedItem.m_41619_()) {
                if (button == 0) {
                    ItemStack copy = carriedItem.m_41777_();
                    copy.m_41764_(1);
                    this.flagStorage.setStackDirectly(slot.getSlotIndex(), new ItemStackType(copy));
                } else if (button == 1) {
                    ItemStack copy = carriedItem.m_41777_();
                    copy.m_41764_(1);
                    CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                        Function<?, IStackHandlerWrapper<?>> handlerGetter;
                        IStackHandlerWrapper<?> stackHandlerWrapper;
                        Object handler = copy.getCapability(cap).orElse(null);
                        if (handler != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                            for (int index = 0; index < stackHandlerWrapper.getSlots(); ++index) {
                                IStackType<?> stack = StackCreater.Create(typeId, stackHandlerWrapper.getStackInSlot(0), 1L);
                                if (stack == null || stack.isEmpty()) continue;
                                this.flagStorage.setStackDirectly(slot.getSlotIndex(), stack);
                                break;
                            }
                        }
                    });
                }
            }
        } else if (carriedItem.m_41619_()) {
            this.flagStorage.setStackDirectly(slot.getSlotIndex(), new ItemStackType());
        } else {
            this.flagStorage.setStackDirectly(slot.getSlotIndex(), new ItemStackType());
        }
    }
}

