/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu.Slot;

import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.StackCreater;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class StoredStackSlot
extends Slot {
    private static final Container empty_inv = new SimpleContainer(0);
    private final IStackTypedHandler stackTypedHandler;
    private int theSlot;
    private boolean fake;
    private boolean active = true;

    public StoredStackSlot(IStackTypedHandler stackTypedHandler, int slotIndex, int xPosition, int yPosition) {
        super(empty_inv, slotIndex, xPosition, yPosition);
        this.theSlot = slotIndex;
        this.stackTypedHandler = stackTypedHandler;
    }

    public IStackType getTypedStackFromUnifiedStorage() {
        IStackType stackType = this.stackTypedHandler.getStackBySlot(this.getSlotIndex());
        if (stackType != null) {
            return stackType.copy();
        }
        return new ItemStackType();
    }

    public ItemStack getItemStackFromUnifiedStorage() {
        IStackType stackType = this.stackTypedHandler.getStackBySlot(this.getSlotIndex());
        if (stackType == null) {
            return ItemStack.f_41583_;
        }
        if (stackType instanceof ItemStackType) {
            ItemStackType itemStackType = (ItemStackType)stackType;
            return itemStackType.getStack();
        }
        return ItemStack.f_41583_;
    }

    public IStackType getVanillaActualStack() {
        IStackType stack = this.getTypedStackFromUnifiedStorage();
        if (stack.isEmpty()) {
            return stack;
        }
        if (stack != null) {
            if (stack.getStackAmount() > stack.getVanillaMaxStackSize()) {
                return stack.copyWithCount(stack.getVanillaMaxStackSize());
            }
            return stack.copy();
        }
        return new ItemStackType();
    }

    public IStackType getVanillaMaxSizeStack() {
        IStackType stack = this.getTypedStackFromUnifiedStorage();
        if (stack.isEmpty()) {
            return stack;
        }
        if (stack != null) {
            return stack.copyWithCount(stack.getVanillaMaxStackSize());
        }
        return new ItemStackType();
    }

    public IStackType getStack() {
        if (this.getSlotIndex() < 0 || this.getSlotIndex() >= this.stackTypedHandler.getSlots()) {
            return new ItemStackType(ItemStack.f_41583_);
        }
        IStackType stack = this.stackTypedHandler.getStackBySlot(this.getSlotIndex());
        if (stack.isEmptyStack()) {
            return StackCreater.CreateEmpty(stack.getTypeId());
        }
        if (stack != null) {
            return stack.copy();
        }
        return new ItemStackType(ItemStack.f_41583_);
    }

    public ItemStack m_7993_() {
        if (this.getSlotIndex() < 0) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = this.getItemStackFromUnifiedStorage();
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (itemStack != null) {
            return itemStack.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6657_() {
        return this.stackTypedHandler.getStackBySlot(this.getSlotIndex()) != null && !this.stackTypedHandler.getStackBySlot(this.getSlotIndex()).isEmpty();
    }

    public void m_5852_(ItemStack stack) {
        if (stack == ItemStack.f_41583_ || stack == null || this.getSlotIndex() < 0) {
            return;
        }
        if (this.stackTypedHandler.getStorage().size() > this.getSlotIndex()) {
            this.stackTypedHandler.setStackDirectly(this.getSlotIndex(), new ItemStackType(stack.m_41777_()));
        } else if (this.stackTypedHandler.getStorage().size() == this.getSlotIndex()) {
            this.stackTypedHandler.addStackToIndexDirectly(this.getSlotIndex(), new ItemStackType(stack.m_41777_()));
        } else {
            while (this.stackTypedHandler.getStorage().size() < this.getSlotIndex()) {
                this.stackTypedHandler.addStackDirectly(new ItemStackType(ItemStack.f_41583_));
            }
            this.stackTypedHandler.addStackToIndexDirectly(this.getSlotIndex(), new ItemStackType(stack.m_41777_()));
        }
        this.m_6654_();
    }

    public void m_269060_(ItemStack newStack) {
        this.stackTypedHandler.insert(new ItemStackType(newStack.m_41777_()), false);
        this.m_6654_();
    }

    public void m_6654_() {
        this.stackTypedHandler.onChange();
    }

    public int m_6641_() {
        return Integer.MAX_VALUE;
    }

    public int m_5866_(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public ItemStack m_6201_(int amount) {
        if (this.m_7993_() == ItemStack.f_41583_ || this.m_7993_() == null) {
            return ItemStack.f_41583_;
        }
        IStackType typedStack = this.stackTypedHandler.extract(this.getSlotIndex(), amount, true);
        if (typedStack instanceof ItemStackType) {
            ItemStackType trueExtract = (ItemStackType)this.stackTypedHandler.extract(this.getSlotIndex(), amount, false);
            return trueExtract.copyStack();
        }
        return ItemStack.f_41583_;
    }

    public int getSlotIndex() {
        return this.theSlot;
    }

    public boolean isSameInventory(Slot other) {
        if (other instanceof StoredStackSlot) {
            return this.stackTypedHandler == ((StoredStackSlot)other).stackTypedHandler;
        }
        return false;
    }

    public ItemStack m_150656_(ItemStack stack, int increment) {
        if (!stack.m_41619_() && this.m_5857_(stack)) {
            ItemStack itemstack = this.m_7993_();
            int i = Math.min(Math.min(increment, stack.m_41613_()), this.m_5866_(stack) - itemstack.m_41613_());
            this.m_269060_(stack.m_41620_(i));
        }
        return stack;
    }

    public int m_150661_() {
        return this.theSlot;
    }

    public void setTheSlotIndex(int index) {
        this.theSlot = index;
    }

    public long getItemCount() {
        if (this.getSlotIndex() < 0) {
            return -1L;
        }
        IStackType stack = this.stackTypedHandler.getStackBySlot(this.getSlotIndex());
        if (stack != null && !stack.isEmpty()) {
            return stack.getStackAmount();
        }
        return -1L;
    }

    public boolean isFake() {
        return this.fake;
    }

    public void setFake(boolean fake) {
        this.fake = fake;
    }

    public boolean m_6659_() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

