/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class IngredientRenderer {
    private static final int TEXTURE_SIZE = 16;
    private static final int MIN_FLUID_HEIGHT = 1;

    public static void drawTiledSprite(GuiGraphics guiGraphics, int tiledWidth, int tiledHeight, int color, long scaledAmount, TextureAtlasSprite sprite, int posX, int posY) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        IngredientRenderer.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        long yTileCount = scaledAmount / 16L;
        long yRemainder = scaledAmount - yTileCount * 16L;
        int yStart = tiledHeight + posY;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int yTile = 0;
            while ((long)yTile <= yTileCount) {
                int width = xTile == xTileCount ? xRemainder : 16;
                long height = (long)yTile == yTileCount ? yRemainder : 16L;
                int x = posX + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width > 0 && height > 0L) {
                    long maskTop = 16L - height;
                    int maskRight = 16 - width;
                    IngredientRenderer.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
                }
                ++yTile;
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 256.0f;
        float green = (float)(color >> 8 & 0xFF) / 256.0f;
        float blue = (float)(color & 0xFF) / 256.0f;
        float alpha = 1.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, long maskTop, long maskRight, float zLevel) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix, xCoord, yCoord + 16.0f, zLevel).m_7421_(uMin, vMax).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).m_7421_(uMax, vMax).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).m_7421_(uMax, vMin).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord, yCoord + (float)maskTop, zLevel).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }
}

