/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackType
implements IStackType<ItemStack> {
    public static final ResourceLocation ID;
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    private Item item;
    @Nullable
    private CompoundTag tag;
    @Nullable
    private CompoundTag caps;
    private long stackSize;
    private ItemStack cachedStack = null;
    private int vanillaStackSize = -1;
    private int hashCodeCache = 0;
    private boolean NeedRecalHash = true;
    private static final MethodHandle SERIALIZE_CAPS_HANDLE;
    private static final MethodHandle DESERIALIZE_CAPS_HANDLE;

    @Nullable
    public static CompoundTag serializeStackCaps(ItemStack stack) {
        try {
            CompoundTag caps = SERIALIZE_CAPS_HANDLE.invokeExact((CapabilityProvider)stack);
            return caps == null || caps.m_128456_() ? null : caps;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to call serializeCaps", ex);
        }
    }

    @Nullable
    public static void deserializeStackCaps(ItemStack stack, CompoundTag caps) {
        try {
            if (caps != null && !caps.m_128456_()) {
                DESERIALIZE_CAPS_HANDLE.invokeExact((CapabilityProvider)stack, caps);
            }
            return;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to call serializeCaps", ex);
        }
    }

    public ItemStackType() {
        this.item = Items.f_41852_;
        this.stackSize = 0L;
    }

    public ItemStackType(ItemStack stack) {
        this.item = stack.m_41720_();
        this.tag = stack.f_41590_ == null ? null : stack.f_41590_.m_6426_();
        CompoundTag caps = ItemStackType.serializeStackCaps(stack);
        this.caps = caps == null ? null : caps.m_6426_();
        this.stackSize = stack.m_41613_();
    }

    public ItemStackType(ItemStack stack, long stackSize) {
        this.item = stack.m_41720_();
        this.tag = stack.f_41590_ == null ? null : stack.f_41590_.m_6426_();
        CompoundTag caps = ItemStackType.serializeStackCaps(stack);
        this.caps = caps == null ? null : caps.m_6426_();
        this.stackSize = stackSize;
    }

    public ItemStackType(Item item, long stackSize, CompoundTag tag, CompoundTag caps) {
        this.item = item;
        this.tag = tag == null ? null : tag.m_6426_();
        this.caps = caps == null ? null : caps.m_6426_();
        this.stackSize = stackSize;
    }

    private void refreshCachedStack() {
        this.cachedStack = new ItemStack((ItemLike)this.item, 1, this.caps == null ? null : this.caps.m_6426_());
        this.cachedStack.f_41590_ = this.tag == null ? null : this.tag.m_6426_();
    }

    @Override
    public IStackType<ItemStack> fromObject(Object key, long amount, CompoundTag dataComponentPatch) {
        if (key instanceof Item) {
            Item item = (Item)key;
            ItemStack itemStack = dataComponentPatch != null ? new ItemStack((ItemLike)item, 1, dataComponentPatch) : new ItemStack((ItemLike)item, 1);
            return new ItemStackType(itemStack, amount);
        }
        return null;
    }

    @Override
    public ItemStack getStack() {
        if (this.cachedStack == null) {
            this.refreshCachedStack();
        }
        this.cachedStack.m_41764_(BDMath.clampLongToInt(this.stackSize));
        return this.cachedStack;
    }

    @Override
    public void setStack(ItemStack stack) {
        this.item = stack.m_41720_();
        this.tag = stack.f_41590_ == null ? null : stack.f_41590_.m_6426_();
        CompoundTag caps = ItemStackType.serializeStackCaps(stack);
        this.caps = caps == null ? null : caps.m_6426_();
        this.NeedRecalHash = true;
        this.refreshCachedStack();
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public IStackType<ItemStack> getEmpty() {
        return new ItemStackType();
    }

    @Override
    public Class<ItemStack> getStackClass() {
        return ItemStack.class;
    }

    @Override
    public Class<?> getSourceClass() {
        return Item.class;
    }

    @Override
    public Object getSource() {
        return ItemStack.f_41583_.m_41720_();
    }

    @Override
    public String getModId() {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)this.item);
        return key != null ? key.m_135827_() : "unknown";
    }

    @Override
    public boolean isEmpty() {
        return this.item == Items.f_41852_ || this.stackSize <= 0L;
    }

    @Override
    public boolean isEmptyStack() {
        return this.item == Items.f_41852_;
    }

    @Override
    public ItemStack getEmptyStack() {
        return ItemStack.f_41583_;
    }

    @Override
    public ItemStack copyStack() {
        ItemStack copy = new ItemStack((ItemLike)this.item, BDMath.clampLongToInt(this.stackSize), this.caps == null ? null : this.caps.m_6426_());
        copy.f_41590_ = this.tag == null ? null : this.tag.m_6426_();
        return copy;
    }

    @Override
    public ItemStack copyStackWithCount(long count) {
        ItemStack copy = new ItemStack((ItemLike)this.item, BDMath.clampLongToInt(count), this.caps == null ? null : this.caps.m_6426_());
        copy.f_41590_ = this.tag == null ? null : this.tag.m_6426_();
        return copy;
    }

    @Override
    public IStackType<ItemStack> copy() {
        Item copyItem = this.item;
        CompoundTag copyTag = this.tag == null ? null : this.tag.m_6426_();
        CompoundTag copyCaps = this.caps == null ? null : this.caps.m_6426_();
        long copyStackSize = this.stackSize;
        ItemStackType copy = new ItemStackType(copyItem, copyStackSize, copyTag, copyCaps);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<ItemStack> copyWithCount(long count) {
        Item copyItem = this.item;
        CompoundTag copyTag = this.tag == null ? null : this.tag.m_6426_();
        CompoundTag copyCaps = this.caps == null ? null : this.caps.m_6426_();
        long copyStackSize = count;
        ItemStackType copy = new ItemStackType(copyItem, copyStackSize, copyTag, copyCaps);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public long getStackAmount() {
        return this.stackSize;
    }

    @Override
    public void setStackAmount(long amount) {
        this.stackSize = amount;
    }

    @Override
    public void grow(long amount) {
        this.setStackAmount(this.getStackAmount() + amount);
    }

    @Override
    public void shrink(long amount) {
        this.grow(-amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        if (this.vanillaStackSize <= 0) {
            if (this.cachedStack == null) {
                this.refreshCachedStack();
            }
            this.vanillaStackSize = this.cachedStack.m_41741_();
        }
        return Math.min((long)this.vanillaStackSize, this.getCustomMaxStackSize());
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public ItemStack splitStack(long amount) {
        if (amount <= 0L) {
            return ItemStack.f_41583_;
        }
        int splitAmount = BDMath.clampLongToInt(Math.min(amount, this.stackSize));
        ItemStack split = this.copyStack();
        split.m_41764_(splitAmount);
        this.shrink(splitAmount);
        return split;
    }

    @Override
    public IStackType<ItemStack> split(long amount) {
        if (amount <= 0L) {
            return new ItemStackType();
        }
        long splitAmount = Math.min(amount, this.stackSize);
        ItemStackType split = (ItemStackType)this.copyWithCount(splitAmount);
        this.shrink(splitAmount);
        return split;
    }

    @Override
    public boolean isSame(IStackType<?> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return this.item == ((ItemStackType)other).item;
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<?> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        if (other instanceof ItemStackType) {
            ItemStackType otherStackType = (ItemStackType)other;
            return otherStackType.item == this.item && Objects.equals(otherStackType.tag, this.tag) && Objects.equals(otherStackType.caps, this.caps);
        }
        return false;
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.m_130085_(this.getTypeId());
        boolean hasItem = this.item != Items.f_41852_;
        buf.writeBoolean(hasItem);
        if (hasItem) {
            buf.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)this.item);
            buf.m_130103_(this.stackSize);
            buf.m_130079_(this.tag);
            buf.m_130079_(this.caps);
        }
    }

    public ItemStackType deserialize(FriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        boolean hasItem = buf.readBoolean();
        if (!hasItem) {
            return new ItemStackType();
        }
        Item item = (Item)buf.m_236816_((IdMap)BuiltInRegistries.f_257033_);
        long count = buf.m_130258_();
        CompoundTag tag = buf.m_130260_();
        CompoundTag caps = buf.m_130260_();
        return new ItemStackType(item, count, tag, caps);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", ID.toString());
        tag.m_128356_("Amount", this.getStackAmount());
        CompoundTag stackTag = new CompoundTag();
        ResourceLocation resourcelocation = BuiltInRegistries.f_257033_.m_7981_((Object)this.item);
        stackTag.m_128359_("id", resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        if (this.tag != null) {
            stackTag.m_128365_("tag", (Tag)this.tag.m_6426_());
        }
        if (this.caps != null && !this.caps.m_128456_()) {
            stackTag.m_128365_("ForgeCaps", (Tag)this.caps);
        }
        tag.m_128365_("Stack", (Tag)stackTag);
        return tag;
    }

    public ItemStackType deserializeNBT(CompoundTag nbt) {
        long amount = nbt.m_128454_("Amount");
        CompoundTag stackTag = nbt.m_128469_("Stack");
        CompoundTag caps = stackTag.m_128441_("ForgeCaps") ? stackTag.m_128469_("ForgeCaps") : null;
        CompoundTag tag = stackTag.m_128441_("tag") ? stackTag.m_128469_("tag") : null;
        Item rawItem = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(stackTag.m_128461_("id")));
        Item item = (Item)ForgeRegistries.ITEMS.getDelegateOrThrow((Object)rawItem).get();
        return new ItemStackType(item, amount, tag, caps);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        if (this.cachedStack == null) {
            this.refreshCachedStack();
        }
        PoseStack poseStack = gui.m_280168_();
        poseStack.m_85836_();
        this.cachedStack.m_41764_(1);
        gui.m_280203_(this.cachedStack, x, y);
        gui.m_280302_(Minecraft.m_91087_().f_91062_, this.cachedStack, x, y, "");
        poseStack.m_85849_();
        String countText = this.getCountText(this.getStackAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.m_280168_();
        poseStackText.m_85836_();
        poseStackText.m_252880_(0.0f, 0.0f, 200.0f);
        poseStackText.m_85841_(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.m_91087_().f_91062_.m_92895_(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!this.cachedStack.m_41619_()) {
            gui.m_280488_(Minecraft.m_91087_().f_91062_, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.m_85849_();
    }

    @Override
    public String getCountText(long count) {
        if (count < 0L) {
            return "";
        }
        return StringFormat.formatCount(count);
    }

    @Override
    public Component getDisplayName() {
        if (this.cachedStack == null) {
            this.refreshCachedStack();
        }
        return this.cachedStack.m_41611_();
    }

    @Override
    public List<Component> getTooltipLines(@Nullable Player player, TooltipFlag tooltipFlag) {
        if (this.cachedStack == null) {
            this.refreshCachedStack();
        }
        List tooltips = this.cachedStack.m_41651_(player, tooltipFlag);
        tooltips.add(Component.m_237110_((String)"istack.beyonddimensions.storage_num.item", (Object[])new Object[]{this.getStackAmount()}));
        return tooltips;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage() {
        if (this.cachedStack == null) {
            this.refreshCachedStack();
        }
        return this.cachedStack.m_150921_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics gui, Font font, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        gui.renderTooltip(minecraft.f_91062_, this.getTooltipLines((Player)minecraft.f_91074_, (TooltipFlag)(minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)), this.getTooltipImage(), ItemStack.f_41583_, mouseX, mouseY);
    }

    public boolean equals(Object other) {
        if (other instanceof ItemStackType) {
            ItemStackType otherStack = (ItemStackType)other;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        if (this.NeedRecalHash) {
            int i = 31 + this.item.hashCode();
            if (this.tag != null) {
                i = i * 31 + this.tag.hashCode();
            }
            if (this.caps != null) {
                i = i * 31 + this.caps.hashCode();
            }
            this.hashCodeCache = i;
            this.NeedRecalHash = false;
        }
        return this.hashCodeCache;
    }

    static {
        Method method;
        ID = ResourceLocation.m_214293_((String)"beyonddimensions", (String)"stack_type/item");
        try {
            method = CapabilityProvider.class.getDeclaredMethod("serializeCaps", new Class[0]);
            method.setAccessible(true);
            SERIALIZE_CAPS_HANDLE = MethodHandles.lookup().unreflect(method);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create serializeCaps method handle", exception);
        }
        try {
            method = CapabilityProvider.class.getDeclaredMethod("deserializeCaps", CompoundTag.class);
            method.setAccessible(true);
            DESERIALIZE_CAPS_HANDLE = MethodHandles.lookup().unreflect(method);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create deserializeCaps method handle", exception);
        }
    }
}

