/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Storage.Chemicals;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.Chemicals.GasStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import mekanism.api.Action;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;

public class GasUnifiedStorageHandler
implements IGasHandler {
    private UnifiedStorage storage;

    public GasUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getTanks() {
        return this.storage.getTypeIdIndexList(GasStackType.ID).map(list -> this.storage.isFullSlotsSize() ? list.size() : list.size() + 1).orElse(this.storage.isFullSlotsSize() ? 0 : 1);
    }

    public GasStack getChemicalInTank(int slot) {
        return this.storage.getTypeIdIndexList(GasStackType.ID).filter(slots -> slot >= 0 && slot < slots.size()).map(slots -> (Integer)slots.get(slot)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (GasStackType)this.storage.getStackBySlot((int)actualIndex)).map(GasStackType::getStack).orElse(GasStack.EMPTY);
    }

    public void setChemicalInTank(int tank, GasStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        this.storage.insert(new GasStackType(stack.copy()), false);
    }

    public long getTankCapacity(int tank) {
        return this.storage.getSlotCapacity(0);
    }

    public boolean isValid(int tank, GasStack stack) {
        return true;
    }

    public GasStack insertChemical(int tank, GasStack stack, Action action) {
        if (stack.isEmpty()) {
            return GasStack.EMPTY;
        }
        long remaining = this.storage.insert(new GasStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new GasStack(stack, remaining);
        }
        return GasStack.EMPTY;
    }

    public GasStack extractChemical(int tank, long amount, Action action) {
        return ((GasStackType)this.storage.extract(new GasStackType(new GasStack(this.getChemicalInTank(tank), amount)), action.simulate())).copyStack();
    }

    public GasStack insertChemical(GasStack stack, Action action) {
        if (stack.isEmpty()) {
            return GasStack.EMPTY;
        }
        long remaining = this.storage.insert(new GasStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new GasStack(stack, remaining);
        }
        return GasStack.EMPTY;
    }

    public GasStack extractChemical(long amount, Action action) {
        return ((GasStackType)this.storage.extract(new GasStackType(new GasStack(this.getChemicalInTank(0), amount)), action.simulate())).copyStack();
    }

    public GasStack extractChemical(GasStack stack, Action action) {
        return ((GasStackType)this.storage.extract(new GasStackType(stack.copy()), action.simulate())).copyStack();
    }
}

