/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.BaseMachineBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Machine.FilterMode;
import com.wintercogs.beyonddimensions.Machine.HopperFluidMode;
import com.wintercogs.beyonddimensions.Machine.HopperNBTMode;
import com.wintercogs.beyonddimensions.Machine.HopperRangeMode;
import com.wintercogs.beyonddimensions.Menu.NetHopperMenu;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;

public class NetHopperBlockEntity
extends BaseMachineBlockEntity
implements MenuProvider {
    private static final int capacity = 36;
    private final StackTypedHandler filterSlots = new StackTypedHandler(36){

        @Override
        public void onChange() {
            if (!NetHopperBlockEntity.this.f_58857_.m_5776_()) {
                NetHopperBlockEntity.this.f_58857_.m_151543_(NetHopperBlockEntity.this.f_58858_);
            }
        }
    };
    public FilterMode filterMode = FilterMode.BLACK;
    public HopperFluidMode hopperFluidMode = HopperFluidMode.DENY;
    public HopperNBTMode hopperNBTMode = HopperNBTMode.DENY;
    public HopperRangeMode hopperRangeMode = HopperRangeMode.RADIUS_MID;
    private List<ItemEntity> itemEntities = new ArrayList<ItemEntity>();

    public NetHopperBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_HOPPER_BLOCK_ENTITY.get(), pos, blockState);
    }

    @Override
    public boolean shouldWork() {
        return super.shouldWork() && this.getNet() != null;
    }

    @Override
    public int getTicksPerWork() {
        return switch (this.hopperRangeMode) {
            default -> throw new IncompatibleClassChangeError();
            case HopperRangeMode.RADIUS_LOWEST -> 5;
            case HopperRangeMode.RADIUS_LOW -> 10;
            case HopperRangeMode.RADIUS_MID -> 20;
            case HopperRangeMode.RADIUS_HIGH -> 60;
            case HopperRangeMode.RADIUS_HIGHEST -> 100;
            case HopperRangeMode.CHUNK_MODE -> 1200;
        };
    }

    @Override
    public void workStart() {
        this.refreshItemEntityCache(this.getSearchArea());
    }

    @Override
    public void workContent() {
        for (ItemEntity itemEntity : this.itemEntities) {
            UnifiedStorage storage;
            ItemStack itemStack;
            ItemStackType typedStack;
            if (itemEntity == null || itemEntity.m_213877_() || !this.matchesFilter(typedStack = new ItemStackType(itemStack = itemEntity.m_32055_().m_41777_())) || !(storage = this.getNet().getUnifiedStorage()).insert(typedStack, true).isEmpty()) continue;
            itemEntity.m_146870_();
            this.getNet().getUnifiedStorage().insert(typedStack, false);
        }
        if (this.hopperFluidMode == HopperFluidMode.ALLOW) {
            this.fluidCollect(this.getSearchArea());
        }
    }

    private AABB getSearchArea() {
        if (this.hopperRangeMode != HopperRangeMode.CHUNK_MODE) {
            int radius = switch (this.hopperRangeMode) {
                case HopperRangeMode.RADIUS_LOWEST -> 2;
                case HopperRangeMode.RADIUS_LOW -> 3;
                case HopperRangeMode.RADIUS_MID -> 5;
                case HopperRangeMode.RADIUS_HIGH -> 7;
                case HopperRangeMode.RADIUS_HIGHEST -> 10;
                default -> 1;
            };
            return new AABB((double)(this.f_58858_.m_123341_() - radius), (double)(this.f_58858_.m_123342_() - radius), (double)(this.f_58858_.m_123343_() - radius), (double)(this.f_58858_.m_123341_() + radius), (double)(this.f_58858_.m_123342_() + radius), (double)(this.f_58858_.m_123343_() + radius));
        }
        int chunkX = SectionPos.m_123171_((int)this.f_58858_.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)this.f_58858_.m_123343_());
        int minX = chunkX << 4;
        int maxX = minX + 15;
        int minZ = chunkZ << 4;
        int maxZ = minZ + 15;
        int minY = this.f_58857_.m_141937_();
        int maxY = this.f_58857_.m_151558_();
        return new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private void refreshItemEntityCache(AABB searchArea) {
        this.itemEntities = this.f_58857_.m_6443_(ItemEntity.class, searchArea, itemEntity -> {
            if (this.hopperNBTMode == HopperNBTMode.DENY) {
                return !itemEntity.m_32055_().m_41782_();
            }
            return true;
        });
    }

    private void fluidCollect(AABB searchArea) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        int minX = Mth.m_14107_((double)searchArea.f_82288_);
        int minY = Mth.m_14107_((double)searchArea.f_82289_);
        int minZ = Mth.m_14107_((double)searchArea.f_82290_);
        int maxX = Mth.m_14107_((double)searchArea.f_82291_);
        int maxY = Mth.m_14107_((double)searchArea.f_82292_);
        int maxZ = Mth.m_14107_((double)searchArea.f_82293_);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    pos.m_122178_(x, y, z);
                    FluidState fluidState = this.f_58857_.m_6425_((BlockPos)pos);
                    if (fluidState.m_76178_()) continue;
                    int amount = fluidState.m_76170_() ? 1000 : 0;
                    FluidStack extracted = new FluidStack(fluidState.m_76152_(), amount);
                    UnifiedStorage storage = this.getNet().getUnifiedStorage();
                    FluidStackType typedFluid = new FluidStackType(extracted);
                    if (!this.matchesFilter(typedFluid) || !storage.insert(typedFluid, true).isEmpty()) continue;
                    storage.insert(typedFluid, false);
                    this.f_58857_.m_7731_((BlockPos)pos, Blocks.f_50016_.m_49966_(), 11);
                }
            }
        }
    }

    private boolean matchesFilter(IStackType otherStack) {
        switch (this.filterMode) {
            case BLACK: {
                for (IStackType stack : this.filterSlots.getStorage()) {
                    if (!stack.isSame(otherStack)) continue;
                    return false;
                }
                return true;
            }
            case WHITE: {
                for (IStackType stack : this.filterSlots.getStorage()) {
                    if (!stack.isSame(otherStack)) continue;
                    return true;
                }
                return false;
            }
            case IGNORE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.filterSlots.deserializeNBT(tag.m_128469_("filter_slots"));
        this.filterMode = FilterMode.valueOf(tag.m_128461_("filter_type"));
        this.hopperFluidMode = HopperFluidMode.valueOf(tag.m_128461_("hopper_fluid_mode"));
        this.hopperNBTMode = HopperNBTMode.valueOf(tag.m_128461_("hopper_nbt_mode"));
        this.hopperRangeMode = HopperRangeMode.valueOf(tag.m_128461_("hopper_range_mode"));
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("filter_slots", (Tag)this.filterSlots.serializeNBT());
        tag.m_128359_("filter_type", this.filterMode.name());
        tag.m_128359_("hopper_fluid_mode", this.hopperFluidMode.name());
        tag.m_128359_("hopper_nbt_mode", this.hopperNBTMode.name());
        tag.m_128359_("hopper_range_mode", this.hopperRangeMode.name());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"menu.title.beyonddimensions.hopper_menu");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new NetHopperMenu(containerId, inventory, this.filterSlots, this);
    }
}

