/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.ButtonState;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.Config;
import com.wintercogs.beyonddimensions.Integration.JECharacters.PinInMatches;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Menu.Slot.DisorderedSlotGroupSync;
import com.wintercogs.beyonddimensions.Menu.Slot.DisorderedStackTypedSlot;
import com.wintercogs.beyonddimensions.Registry.UIRegister;
import com.wintercogs.beyonddimensions.Unit.TinyPinyinUtils;
import com.wintercogs.beyonddimensions.Unit.TooltipHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.TooltipFlag;

public class DimensionsNetMenu
extends BDBaseMenu {
    public int maxLines = 6;
    public int lineData = 0;
    public int maxLineData = 0;
    private String searchText = "";
    public UnifiedStorage storage;
    public UnifiedStorage viewerStorage;
    private ArrayList<Integer> cacheIndex;
    private boolean cacheTooltip = false;
    public boolean hasShiftDown = false;
    protected int storageStartIndex;
    protected int storageEndIndex;

    public DimensionsNetMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(UIRegister.Dimensions_Net_Menu.get(), id, playerInventory, new DimensionsNet(true));
    }

    public DimensionsNetMenu(MenuType<?> menuType, int id, Inventory playerInventory, DimensionsNet data) {
        super(menuType, id, playerInventory);
        if (this.player.m_9236_().m_5776_()) {
            this.maxLines = Config.uiPageNum;
            this.searchText = Config.uiSearch;
        }
        this.storage = data.getUnifiedStorage();
        this.viewerStorage = new DimensionsNet(true).getUnifiedStorage();
        this.addSlotGroupSync(new DisorderedSlotGroupSync(this, this.slotGroupSyncs.size(), this.storage){

            @Override
            public void afterLoadChange() {
                if (!DimensionsNetMenu.this.hasShiftDown) {
                    DimensionsNetMenu.this.updateViewerStorage();
                } else {
                    DimensionsNetMenu.this.updateOnlyCountAndNewViewer();
                }
                if (!DimensionsNetMenu.this.cacheTooltip) {
                    TooltipHelper.readAsCache(DimensionsNetMenu.this.storage.getStorage(), DimensionsNetMenu.this.player, (TooltipFlag)TooltipFlag.Default.f_256752_);
                    TooltipHelper.readAsCache(DimensionsNetMenu.this.storage.getStorage(), DimensionsNetMenu.this.player, (TooltipFlag)TooltipFlag.Default.f_256730_);
                }
            }
        });
        this.addPlayerInv(playerInventory);
        this.addStorageSlots();
    }

    public int getLines() {
        return this.maxLines;
    }

    public void reduceLines() {
        --this.maxLines;
    }

    public void addLines() {
        ++this.maxLines;
    }

    public void setLines(int lines) {
        this.maxLines = lines;
    }

    protected void addStorageSlots() {
        this.vanillaQuickMoveStartIndex = this.storageStartIndex = this.f_38839_.size();
        if (this.player.m_9236_().m_5776_()) {
            for (int row = 0; row < 99; ++row) {
                for (int col = 0; col < 9; ++col) {
                    DisorderedStackTypedSlot newSlot = new DisorderedStackTypedSlot(this, this.viewerStorage, -1, this.inventoryStartIndex, this.inventoryEndIndex, 8 + col * 18, 25 + row * 18);
                    if (row >= this.getLines()) {
                        newSlot.setActive(false);
                    }
                    this.m_38897_(newSlot);
                }
            }
        } else {
            for (int row = 0; row < 99; ++row) {
                for (int col = 0; col < 9; ++col) {
                    DisorderedStackTypedSlot newSlot = new DisorderedStackTypedSlot(this, this.storage, -1, this.inventoryStartIndex, this.inventoryEndIndex, 8 + col * 18, 25 + row * 18);
                    if (row >= this.getLines()) {
                        newSlot.setActive(false);
                    }
                    this.m_38897_(newSlot);
                }
            }
        }
        this.vanillaQuickMoveEndIndex = this.storageEndIndex = this.f_38839_.size();
    }

    protected void addPlayerInv(Inventory playerInventory) {
        this.inventoryStartIndex = this.f_38839_.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 25 + (this.getLines() - 1) * 18 + 26 + 6 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 25 + (this.getLines() - 1) * 18 + 26 + 6 + 54 + 4));
        }
        this.inventoryEndIndex = this.f_38839_.size();
    }

    public void rebuildSlots() {
        int sSlotNum = 0;
        for (Slot slot : this.f_38839_) {
            if (!(slot instanceof AbstractStackTypedSlot)) continue;
            AbstractStackTypedSlot sSlot = (AbstractStackTypedSlot)slot;
            if (sSlotNum / 9 < this.getLines()) {
                sSlot.setActive(true);
            } else {
                sSlot.setActive(false);
            }
            ++sSlotNum;
        }
        int slotNum = 0;
        for (int i = this.inventoryStartIndex; i < this.inventoryEndIndex; ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (slot == null) continue;
            slot.f_40221_ = slotNum / 9 < 3 ? 25 + (this.getLines() - 1) * 18 + 26 + 6 + slotNum / 9 * 18 : 25 + (this.getLines() - 1) * 18 + 26 + 6 + 54 + 4;
            ++slotNum;
        }
    }

    public void updateViewerStorage() {
        this.viewerStorage.clearStorage();
        for (IStackType stack : this.storage.getStorage()) {
            this.viewerStorage.insert(stack.copy(), false);
        }
        this.buildIndexList(new ArrayList<IStackType>(this.viewerStorage.getStorage()), true);
    }

    public void updateOnlyCountAndNewViewer() {
        HashMap<IStackType, Long> storageMap = new HashMap<IStackType, Long>();
        for (IStackType stack : this.storage.getStorage()) {
            storageMap.put(stack, stack.getStackAmount());
        }
        for (IStackType viewerStack : this.viewerStorage.getStorage()) {
            long amount = storageMap.getOrDefault(viewerStack, 0L);
            viewerStack.setStackAmount(amount);
        }
    }

    public void buildIndexList(ArrayList<IStackType> itemStorage, boolean needsUpdateCacheIndex) {
        if (!this.player.m_9236_().m_5776_()) {
            return;
        }
        if (needsUpdateCacheIndex || this.cacheIndex == null) {
            this.cacheIndex = this.buildStorageWithCurrentState(new ArrayList<IStackType>(itemStorage));
        }
        this.updateScrollLineData(this.cacheIndex.size());
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < this.getLines() * 9; ++i) {
            if (i + this.lineData * 9 < this.cacheIndex.size()) {
                int index = this.cacheIndex.get(i + this.lineData * 9);
                indexList.add(index);
                continue;
            }
            indexList.add(-1);
        }
        this.loadIndexList(indexList);
    }

    public void loadIndexList(ArrayList<Integer> list) {
        int listIndex = 0;
        for (int slotIndex = this.storageStartIndex; listIndex < list.size() && slotIndex < this.storageEndIndex; ++listIndex, ++slotIndex) {
            ((AbstractStackTypedSlot)((Object)this.f_38839_.get(slotIndex))).setTheSlotIndex(list.get(listIndex));
        }
    }

    public void loadSearchText(String text) {
        this.searchText = text.toLowerCase(Locale.ENGLISH);
    }

    public ArrayList<Integer> buildStorageWithCurrentState(ArrayList<IStackType> unifiedStorage) {
        ArrayList<IStackType> cache = new ArrayList<IStackType>();
        ArrayList<Integer> cacheIndex = new ArrayList<Integer>();
        for (int i = 0; i < unifiedStorage.size(); ++i) {
            boolean hasSymbol;
            IStackType stack = unifiedStorage.get(i);
            if (stack == null || stack.isEmpty()) continue;
            String displayName = stack.getDisplayName().getString().toLowerCase(Locale.ENGLISH);
            String modId = stack.getModId().toLowerCase(Locale.ENGLISH);
            if (this.searchText == null || this.searchText.isEmpty()) {
                cache.add(stack);
                cacheIndex.add(i);
                continue;
            }
            String lowerSearch = this.searchText.toLowerCase(Locale.ENGLISH);
            String[] parts = DimensionsNetMenu.splitSearch(lowerSearch);
            String mainPart = parts[0];
            String idPart = parts[1];
            String tooltipPart = parts[2];
            boolean bl = hasSymbol = !idPart.isEmpty() || !tooltipPart.isEmpty();
            if (hasSymbol) {
                if (!mainPart.isEmpty() && !this.checkTextMatches(displayName, mainPart) || !idPart.isEmpty() && !modId.contains(idPart) || !tooltipPart.isEmpty() && !this.checkTooltipMatches(stack, tooltipPart)) continue;
                cache.add(stack);
                cacheIndex.add(i);
                continue;
            }
            boolean matched = false;
            if (!mainPart.isEmpty() && this.checkTextMatches(displayName, mainPart)) {
                matched = true;
            }
            if (!matched && modId.contains(mainPart)) {
                matched = true;
            }
            if (!matched && this.checkTooltipMatches(stack, mainPart)) {
                matched = true;
            }
            if (!matched) continue;
            cache.add(stack);
            cacheIndex.add(i);
        }
        ButtonState sortState = Config.uiSortButton;
        if (sortState != ButtonState.SORT_DEFAULT) {
            Comparator<IStackType> comparator = sortState == ButtonState.SORT_NAME ? Comparator.comparing(item -> item.getDisplayName().getString()) : (sortState == ButtonState.SORT_QUANTITY ? Comparator.comparingLong(IStackType::getStackAmount) : (sortState == ButtonState.SORT_MODID ? Comparator.comparing(IStackType::getModId) : Comparator.comparing(item -> item.getDisplayName().getString())));
            ArrayList<IStackType> finalCache = cache;
            List indices = IntStream.range(0, cache.size()).parallel().boxed().sorted((a, b) -> comparator.compare((IStackType)finalCache.get((int)a), (IStackType)finalCache.get((int)b))).collect(Collectors.toList());
            ArrayList<Integer> sortedIndices = new ArrayList<Integer>(cacheIndex.size());
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                sortedIndices.add(cacheIndex.get(index));
            }
            cacheIndex = sortedIndices;
        }
        if (Config.uiReverseButton == ButtonState.ENABLED) {
            Collections.reverse(cacheIndex);
        }
        return cacheIndex;
    }

    private boolean checkTextMatches(String srcText, String inputText) {
        boolean matchPinyin;
        srcText = srcText.toLowerCase(Locale.ENGLISH);
        inputText = inputText.toLowerCase(Locale.ENGLISH);
        boolean matchText = srcText.contains(inputText);
        if (!Minecraft.m_91087_().f_91066_.f_92075_.startsWith("zh")) {
            matchPinyin = false;
        } else if (BeyondDimensions.JECharactersLoaded) {
            matchPinyin = PinInMatches.contains(srcText, inputText);
        } else {
            String allPinyin = TinyPinyinUtils.getAllPinyin(srcText, false).toLowerCase(Locale.ENGLISH);
            String firstPinyin = TinyPinyinUtils.getFirstPinYin(srcText).toLowerCase(Locale.ENGLISH);
            matchPinyin = allPinyin.contains(inputText) || firstPinyin.contains(inputText);
        }
        return matchText || matchPinyin;
    }

    private boolean checkTooltipMatches(IStackType stack, String matchText) {
        List<Component> toolTips = TooltipHelper.getTooltipLines(stack, this.player, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
        return toolTips.stream().anyMatch(tooltip -> {
            String tooltipText = tooltip.getString().toLowerCase(Locale.ENGLISH);
            return this.checkTextMatches(tooltipText, matchText);
        });
    }

    private static String[] splitSearch(String s) {
        if (s == null) {
            return new String[]{"", "", ""};
        }
        s = s.toLowerCase(Locale.ENGLISH);
        int at = s.indexOf(64);
        int hash = s.indexOf(35);
        if (at < 0 && hash < 0) {
            return new String[]{s, "", ""};
        }
        String namePart = "";
        String idPart = "";
        String tipPart = "";
        if (at >= 0 && hash >= 0) {
            int first = Math.min(at, hash);
            namePart = s.substring(0, first);
            if (at < hash) {
                idPart = s.substring(at + 1, hash);
                tipPart = s.substring(hash + 1);
            } else {
                tipPart = s.substring(hash + 1, at);
                idPart = s.substring(at + 1);
            }
        } else if (at >= 0) {
            namePart = s.substring(0, at);
            idPart = s.substring(at + 1);
        } else {
            namePart = s.substring(0, hash);
            tipPart = s.substring(hash + 1);
        }
        return new String[]{namePart, idPart, tipPart};
    }

    public void updateScrollLineData(int dataSize) {
        this.maxLineData = dataSize / 9;
        if (dataSize % 9 != 0) {
            ++this.maxLineData;
        }
        this.maxLineData -= this.getLines();
        this.maxLineData = Math.max(this.maxLineData, 0);
        this.lineData = Math.max(this.lineData, 0);
        this.lineData = Math.min(this.lineData, this.maxLineData);
    }

    @Override
    public boolean m_6875_(Player player) {
        return true;
    }
}

