/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetFurnaceBlockEntity;
import com.wintercogs.beyonddimensions.Machine.PopMode;
import com.wintercogs.beyonddimensions.Machine.ReceiveMode;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.FlagStackTypedSlot;
import com.wintercogs.beyonddimensions.Menu.Slot.OrderedStackTypedSlot;
import com.wintercogs.beyonddimensions.Registry.UIRegister;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;

public class NetFurnaceMenu
extends BDBaseMenu {
    private static final int invSlotStartY = 128;
    private final IStackTypedHandler inputFilterSlots;
    private final IStackTypedHandler fuelFilterSlots;
    private final IStackTypedHandler inputStorageSlots;
    private final IStackTypedHandler outputStorageSlots;
    private final IStackTypedHandler fuelStorageSlots;
    private final IStackTypedHandler fuelReturnSlots;
    private List<Integer> lastLitTime = new ArrayList<Integer>();
    private List<Integer> lastLitDuration = new ArrayList<Integer>();
    private List<Integer> lastCookTime = new ArrayList<Integer>();
    private List<Integer> lastCookTimeTotal = new ArrayList<Integer>();
    public final NetFurnaceBlockEntity be;

    public NetFurnaceMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, (NetFurnaceBlockEntity)playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_()));
    }

    public NetFurnaceMenu(int containerId, Inventory playerInventory, NetFurnaceBlockEntity be) {
        super(UIRegister.Net_Furnace_Menu.get(), containerId, playerInventory);
        this.be = be;
        if (playerInventory.f_35978_.m_9236_().m_5776_()) {
            this.inputFilterSlots = new StackTypedHandler(be.getFilterCapacity());
            this.fuelFilterSlots = new StackTypedHandler(be.getFilterCapacity());
            this.inputStorageSlots = new StackTypedHandler(be.getCapacity());
            this.outputStorageSlots = new StackTypedHandler(be.getCapacity());
            this.fuelStorageSlots = new StackTypedHandler(be.getFuelCapacity());
            this.fuelReturnSlots = new StackTypedHandler(be.getFuelCapacity());
        } else {
            this.inputFilterSlots = be.getInputFilterSlots();
            this.fuelFilterSlots = be.getFuelFilterSlots();
            this.inputStorageSlots = be.getInputStorageSlots();
            this.outputStorageSlots = be.getOutputStorageSlots();
            this.fuelStorageSlots = be.getFuelStorageSlots();
            this.fuelReturnSlots = be.getFuelReturnSlots();
        }
        this.addPlayerInv(playerInventory);
        this.addFilterSlots();
        this.addStorageSlots();
    }

    private void addFilterSlots() {
        FlagStackTypedSlot flagSlot;
        int i;
        for (i = 0; i < 8; ++i) {
            flagSlot = new FlagStackTypedSlot(this, this.inputFilterSlots, i, 7, 38 + i * 18);
            this.m_38897_(flagSlot);
        }
        for (i = 0; i < 8; ++i) {
            flagSlot = new FlagStackTypedSlot(this, this.fuelFilterSlots, i, 207, 38 + i * 18);
            this.m_38897_(flagSlot);
        }
    }

    private void addStorageSlots() {
        OrderedStackTypedSlot storageSlot;
        int i;
        this.vanillaQuickMoveStartIndex = this.f_38839_.size();
        for (i = 0; i < 9; ++i) {
            storageSlot = new OrderedStackTypedSlot(this, this.inputStorageSlots, i, this.inventoryStartIndex, this.inventoryEndIndex, 31 + i * 19, 38);
            this.m_38897_(storageSlot);
        }
        this.m_38897_(new OrderedStackTypedSlot(this, this.fuelStorageSlots, 0, this.inventoryStartIndex, this.inventoryEndIndex, 207, 186));
        this.vanillaQuickMoveEndIndex = this.f_38839_.size();
        this.m_38897_(new OrderedStackTypedSlot(this, this.fuelReturnSlots, 0, this.inventoryStartIndex, this.inventoryEndIndex, 7, 186));
        for (i = 0; i < 9; ++i) {
            storageSlot = new OrderedStackTypedSlot(this, this.outputStorageSlots, i, this.inventoryStartIndex, this.inventoryEndIndex, 31 + i * 19, 90);
            this.m_38897_(storageSlot);
        }
    }

    private void addPlayerInv(Inventory playerInventory) {
        this.inventoryStartIndex = this.f_38839_.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 35 + col * 18, 128 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 35 + col * 18, 186));
        }
        this.inventoryEndIndex = this.f_38839_.size();
    }

    @Override
    public boolean m_6875_(Player player) {
        return this.be != null && !this.be.m_58901_();
    }

    @Override
    protected boolean shouldSendQuickData() {
        boolean shouldSendQuickData;
        boolean bl = shouldSendQuickData = super.shouldSendQuickData() || !Objects.equals(this.lastLitTime, this.be.getLitTime()) || !Objects.equals(this.lastLitDuration, this.be.getLitDuration()) || !Objects.equals(this.lastCookTime, this.be.getCookTime()) || !Objects.equals(this.lastCookTimeTotal, this.be.getCookTimeTotal());
        if (shouldSendQuickData) {
            this.lastLitTime = new ArrayList<Integer>(this.be.getLitTime());
            this.lastLitDuration = new ArrayList<Integer>(this.be.getLitDuration());
            this.lastCookTime = new ArrayList<Integer>(this.be.getCookTime());
            this.lastCookTimeTotal = new ArrayList<Integer>(this.be.getCookTimeTotal());
        }
        return shouldSendQuickData;
    }

    @Override
    protected void writeQuickDataTag(CompoundTag tag) {
        super.writeQuickDataTag(tag);
        tag.m_128359_("pop_mode", this.be.popMode.name());
        tag.m_128359_("receive_mode", this.be.receiveMode.name());
        tag.m_128359_("control_mode", this.be.controlMode.name());
        tag.m_128408_("lit_time", this.be.getLitTime());
        tag.m_128408_("lit_duration", this.be.getLitDuration());
        tag.m_128408_("cook_time", this.be.getCookTime());
        tag.m_128408_("cook_time_total", this.be.getCookTimeTotal());
    }

    @Override
    public void readQuickDataTag(CompoundTag tag) {
        super.readQuickDataTag(tag);
        if (!this.player.m_9236_().m_5776_()) {
            this.be.popMode = PopMode.valueOf(tag.m_128461_("pop_mode"));
            this.be.receiveMode = ReceiveMode.valueOf(tag.m_128461_("receive_mode"));
            this.be.controlMode = RedStoneControlMode.valueOf(tag.m_128461_("control_mode"));
            if (!this.player.m_9236_().m_5776_()) {
                this.player.m_9236_().m_151543_(this.be.m_58899_());
                this.player.m_9236_().m_7260_(this.be.m_58899_(), this.be.m_58900_(), this.be.m_58900_(), 2);
            }
        } else {
            this.be.popMode = PopMode.valueOf(tag.m_128461_("pop_mode"));
            this.be.receiveMode = ReceiveMode.valueOf(tag.m_128461_("receive_mode"));
            this.be.controlMode = RedStoneControlMode.valueOf(tag.m_128461_("control_mode"));
            this.be.setLitTime(Arrays.stream(tag.m_128465_("lit_time")).boxed().collect(Collectors.toList()));
            this.be.setLitDuration(Arrays.stream(tag.m_128465_("lit_duration")).boxed().collect(Collectors.toList()));
            this.be.setCookTime(Arrays.stream(tag.m_128465_("cook_time")).boxed().collect(Collectors.toList()));
            this.be.setCookTimeTotal(Arrays.stream(tag.m_128465_("cook_time_total")).boxed().collect(Collectors.toList()));
        }
    }
}

