/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu.Slot;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractStackTypedSlot
extends Slot {
    private static final Container empty_inv = new SimpleContainer(0);
    protected final IStackTypedHandler storage;
    protected final int quickMoveSlotStartIndex;
    protected final int quickMoveSlotEndIndex;
    protected int theSlot;
    protected boolean fake;
    protected boolean active = true;
    protected final BDBaseMenu menu;

    public AbstractStackTypedSlot(BDBaseMenu menu, IStackTypedHandler storage, int slotIndex, int xPosition, int yPosition) {
        super(empty_inv, slotIndex, xPosition, yPosition);
        this.theSlot = slotIndex;
        this.storage = storage;
        this.menu = menu;
        this.quickMoveSlotStartIndex = -1;
        this.quickMoveSlotEndIndex = -1;
    }

    public AbstractStackTypedSlot(BDBaseMenu menu, IStackTypedHandler storage, int slotIndex, int quickMoveSlotStartIndex, int quickMoveSlotEndIndex, int xPosition, int yPosition) {
        super(empty_inv, slotIndex, xPosition, yPosition);
        this.theSlot = slotIndex;
        this.storage = storage;
        this.menu = menu;
        this.quickMoveSlotStartIndex = quickMoveSlotStartIndex;
        this.quickMoveSlotEndIndex = quickMoveSlotEndIndex;
    }

    public IStackTypedHandler getStorage() {
        return this.storage;
    }

    public abstract boolean isOrdered();

    public abstract void click(IStackType var1, int var2, Player var3);

    public abstract void quickMove(IStackType var1, int var2, Player var3);

    public abstract void updateChange();

    public abstract void loadChange(int var1, IStackType var2, long var3);

    public long getSlotCap() {
        return this.storage.getSlotCapacity(this.theSlot);
    }

    public IStackType getTypedStackFromUnifiedStorage() {
        IStackType stackType = this.storage.getStackBySlot(this.getSlotIndex());
        if (stackType != null) {
            return stackType.copy();
        }
        return new ItemStackType();
    }

    public ItemStack getItemStackFromUnifiedStorage() {
        IStackType stackType = this.storage.getStackBySlot(this.getSlotIndex());
        if (stackType == null) {
            return ItemStack.f_41583_;
        }
        if (stackType instanceof ItemStackType) {
            ItemStackType itemStackType = (ItemStackType)stackType;
            return itemStackType.getStack();
        }
        return ItemStack.f_41583_;
    }

    public IStackType getVanillaActualStack() {
        IStackType stack = this.getTypedStackFromUnifiedStorage();
        if (stack.isEmpty()) {
            return stack;
        }
        if (stack != null) {
            if (stack.getStackAmount() > stack.getVanillaMaxStackSize()) {
                return stack.copyWithCount(stack.getVanillaMaxStackSize());
            }
            return stack.copy();
        }
        return new ItemStackType();
    }

    public IStackType getVanillaMaxSizeStack() {
        IStackType stack = this.getTypedStackFromUnifiedStorage();
        if (stack.isEmpty()) {
            return stack;
        }
        if (stack != null) {
            return stack.copyWithCount(stack.getVanillaMaxStackSize());
        }
        return new ItemStackType();
    }

    public IStackType getStack() {
        if (this.getSlotIndex() < 0 || this.getSlotIndex() >= this.storage.getSlots()) {
            return new ItemStackType(ItemStack.f_41583_);
        }
        IStackType stack = this.storage.getStackBySlot(this.getSlotIndex());
        if (stack.isEmptyStack()) {
            return StackCreater.CreateEmpty(stack.getTypeId());
        }
        if (stack != null) {
            return stack.copy();
        }
        return new ItemStackType(ItemStack.f_41583_);
    }

    public boolean hasStack() {
        IStackType stack = this.getStack();
        return stack != null && !stack.isEmpty();
    }

    public void setStackDirectly(IStackType stack) {
    }

    public abstract IStackType safeInsert(IStackType var1);

    public abstract IStackType safeExtract(IStackType var1);

    public void m_6654_() {
        this.storage.onChange();
    }

    public int getSlotIndex() {
        return this.theSlot;
    }

    public boolean isSameInventory(Slot other) {
        if (other instanceof AbstractStackTypedSlot) {
            return this.storage == ((AbstractStackTypedSlot)other).storage;
        }
        return false;
    }

    public int m_150661_() {
        return this.theSlot;
    }

    public void setTheSlotIndex(int index) {
        this.theSlot = index;
    }

    public long getStackCount() {
        if (this.getSlotIndex() < 0) {
            return 0L;
        }
        IStackType stack = this.storage.getStackBySlot(this.getSlotIndex());
        if (stack != null && !stack.isEmpty()) {
            return stack.getStackAmount();
        }
        return 0L;
    }

    public boolean isFake() {
        return this.fake;
    }

    public void setFake(boolean fake) {
        this.fake = fake;
    }

    public boolean m_6659_() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Deprecated
    public ItemStack m_7993_() {
        return ItemStack.f_41583_;
    }

    @Deprecated
    public boolean m_6657_() {
        return false;
    }

    @Deprecated
    public void m_5852_(ItemStack stack) {
    }

    @Deprecated
    public void m_269060_(ItemStack stack) {
    }

    @Deprecated
    public int m_6641_() {
        return 0;
    }

    @Deprecated
    public int m_5866_(ItemStack stack) {
        return 0;
    }

    @Deprecated
    public ItemStack m_6201_(int amount) {
        return ItemStack.f_41583_;
    }

    @Deprecated
    public ItemStack m_150656_(ItemStack stack, int increment) {
        return stack;
    }
}

