/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.wintercogs.beyonddimensions.Api.Registry.StackTypeRegistry;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public interface IStackType<T> {
    public static final Codec<IStackType> CODEC = ResourceLocation.CODEC.dispatch("type", IStackType::getTypeId, id -> {
        IStackType type = StackTypeRegistry.getType(id);
        return type.codec();
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, IStackType> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, IStackType>(){

        public void encode(RegistryFriendlyByteBuf buf, IStackType stackType) {
            stackType.serialize(buf);
        }

        public IStackType decode(RegistryFriendlyByteBuf byteBuf) {
            return IStackType.deserializeCommon(byteBuf);
        }
    };

    public MapCodec<? extends IStackType<T>> codec();

    public IStackType<T> fromObject(Object var1, long var2, DataComponentPatch var4);

    public ResourceLocation getTypeId();

    public IStackType<T> getEmpty();

    public T getStack();

    public void setStack(T var1);

    public Class<T> getStackClass();

    public Class<?> getSourceClass();

    public Object getSource();

    public String getModId();

    public boolean isEmpty();

    public boolean isEmptyStack();

    public T getEmptyStack();

    public T copyStack();

    public T copyStackWithCount(long var1);

    public IStackType<T> copy();

    public IStackType<T> copyWithCount(long var1);

    public long getStackAmount();

    public void setStackAmount(long var1);

    public void grow(long var1);

    public void shrink(long var1);

    public long getVanillaMaxStackSize();

    public long getCustomMaxStackSize();

    public T splitStack(long var1);

    public IStackType<T> split(long var1);

    public boolean isSame(IStackType<?> var1);

    public boolean isSameTypeSameComponents(IStackType<T> var1);

    public void serialize(RegistryFriendlyByteBuf var1);

    public IStackType<T> deserialize(RegistryFriendlyByteBuf var1, ResourceLocation var2);

    public static IStackType deserializeCommon(RegistryFriendlyByteBuf buf) {
        ResourceLocation typeId = buf.readResourceLocation();
        for (IStackType<?> stacktype : StackTypeRegistry.getAllTypes()) {
            IStackType<?> stack = stacktype.deserialize(buf, typeId);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider var1);

    public IStackType<T> deserializeNBT(CompoundTag var1, HolderLookup.Provider var2);

    public static IStackType deserializeNBTCommon(CompoundTag nbt, HolderLookup.Provider levelRegistryAccess) {
        ResourceLocation typeId = ResourceLocation.tryParse((String)nbt.getString("Type"));
        for (IStackType<?> stacktype : StackTypeRegistry.getAllTypes()) {
            IStackType<?> stack;
            if (!stacktype.getTypeId().equals((Object)typeId) || (stack = stacktype.deserializeNBT(nbt, levelRegistryAccess)) == null) continue;
            return stack;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics var1, int var2, int var3);

    public String getCountText(long var1);

    public Component getDisplayName();

    public List<Component> getTooltipLines(Item.TooltipContext var1, @Nullable Player var2, TooltipFlag var3);

    public Optional<TooltipComponent> getTooltipImage();

    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics var1, Font var2, int var3, int var4);
}

