/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.JEI.RecipeTransfer;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Integration.JEI.RecipeTransfer.MissStackError;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenuTerminal;
import com.wintercogs.beyonddimensions.Packet.RecipeFillC2SPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class CraftTerminalRecipeTransferHandler
implements IRecipeTransferHandler<DimensionsCraftMenuTerminal, RecipeHolder<CraftingRecipe>> {
    public Class<? extends DimensionsCraftMenuTerminal> getContainerClass() {
        return DimensionsCraftMenuTerminal.class;
    }

    public Optional<MenuType<DimensionsCraftMenuTerminal>> getMenuType() {
        return Optional.of(DimensionsCraftMenuTerminal.Dimensions_Craft_Menu_Terminal.get());
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(DimensionsCraftMenuTerminal container, RecipeHolder<CraftingRecipe> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        List<Slot> craftingSlots = this.getInputSources(container);
        List<IStackType> storageSlots = container.storage.getStorage();
        ArrayList<ItemStack> availableItems = new ArrayList<ItemStack>();
        for (Slot slot : craftingSlots) {
            if (!slot.hasItem()) continue;
            availableItems.add(slot.getItem());
        }
        for (IStackType stackType : storageSlots) {
            ItemStackType itemStackType;
            ItemStack stack;
            if (!(stackType instanceof ItemStackType) || (stack = (itemStackType = (ItemStackType)stackType).getStack()).isEmpty()) continue;
            availableItems.add(stack);
        }
        for (ItemStack itemStack : container.player.getInventory().items) {
            if (itemStack.isEmpty()) continue;
            availableItems.add(itemStack);
        }
        ArrayList<IRecipeSlotView> missingSlots = new ArrayList<IRecipeSlotView>();
        ArrayList<ItemStack> inputElements = new ArrayList<ItemStack>();
        block3: for (IRecipeSlotView slotView : recipeSlots.getSlotViews(RecipeIngredientRole.INPUT)) {
            if (slotView.getRole() != RecipeIngredientRole.INPUT) continue;
            Ingredient mergedIngredient = Ingredient.of((Stream)slotView.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK));
            if (mergedIngredient.isEmpty()) {
                inputElements.add(ItemStack.EMPTY);
                continue;
            }
            int required = 1;
            ArrayList<ItemStack> matching = new ArrayList<ItemStack>();
            for (ItemStack stack : availableItems) {
                if (stack.isEmpty() || !mergedIngredient.test(stack)) continue;
                matching.add(stack.copy());
            }
            int available = matching.stream().mapToInt(ItemStack::getCount).sum();
            if (available >= required) {
                ItemStack merged = matching.isEmpty() ? ItemStack.EMPTY : ((ItemStack)matching.get(0)).copyWithCount(required);
                inputElements.add(merged);
                int remaining = required;
                for (ItemStack stack : matching) {
                    int deduct = Math.min(remaining, stack.getCount());
                    stack.shrink(deduct);
                    if ((remaining -= deduct) > 0) continue;
                    continue block3;
                }
                continue;
            }
            inputElements.add(ItemStack.EMPTY);
            missingSlots.add(slotView);
        }
        if (doTransfer) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RecipeFillC2SPacket(inputElements), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (!missingSlots.isEmpty()) {
            return new MissStackError(missingSlots);
        }
        return null;
    }

    private List<Slot> getInputSources(DimensionsCraftMenuTerminal menu) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = menu.craftSlotStartIndex; i < menu.craftSlotEndIndex; ++i) {
            slots.add(menu.getSlot(i));
        }
        return slots;
    }
}

