/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Machine;

import com.wintercogs.beyonddimensions.Machine.IMachine;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface BaseMachine
extends IMachine {
    @Override
    default public void working() {
        if (this.shouldWork()) {
            this.workStart();
            this.workContent();
            this.workEnd();
        }
    }

    @Override
    default public void working(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        if (this.shouldWork(stack, level, holder, slotId, isSelected)) {
            this.workStart(stack, level, holder, slotId, isSelected);
            this.workContent(stack, level, holder, slotId, isSelected);
            this.workEnd(stack, level, holder, slotId, isSelected);
        }
    }

    @Override
    default public boolean shouldWork() {
        this.setStepTick(this.getStepTick() + 1);
        if (this.getStepTick() >= this.getTicksPerWork()) {
            this.setStepTick(0);
            RedStoneControlMode controlMode = this.getControlMode();
            if (controlMode == null) {
                return true;
            }
            switch (controlMode) {
                case IGNORE: {
                    return true;
                }
                case NOT_WORKING: {
                    return false;
                }
                case POWERED: {
                    return this.hasRedStoneSignal();
                }
                case UNPOWERED: {
                    return !this.hasRedStoneSignal();
                }
            }
            return false;
        }
        return false;
    }

    @Override
    default public boolean shouldWork(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        RedStoneControlMode controlMode = this.getControlMode(stack);
        if (controlMode == null) {
            return true;
        }
        switch (controlMode) {
            case IGNORE: {
                return true;
            }
            case NOT_WORKING: {
                return false;
            }
            case POWERED: {
                return false;
            }
            case UNPOWERED: {
                return true;
            }
        }
        return false;
    }

    public RedStoneControlMode getControlMode();

    default public RedStoneControlMode getControlMode(ItemStack stack) {
        return RedStoneControlMode.IGNORE;
    }

    public boolean hasRedStoneSignal();

    default public int getTicksPerWork() {
        return 0;
    }

    default public int getTicksPerWork(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        return 0;
    }

    public int getStepTick();

    public void setStepTick(int var1);

    default public void workStart() {
    }

    default public void workContent() {
    }

    default public void workEnd() {
    }

    default public void workStart(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
    }

    default public void workContent(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
    }

    default public void workEnd(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
    }
}

