/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu.Slot;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.FluidHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.Registry.CapabilityHelper;
import com.wintercogs.beyonddimensions.Api.Registry.StackHandlerWrapperHelper;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Packet.OrderedStackTypedSlotPacket;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.network.PacketDistributor;

public class OrderedStackTypedSlot
extends AbstractStackTypedSlot {
    private IStackType lastStack = new ItemStackType();

    public OrderedStackTypedSlot(BDBaseMenu menu, IStackTypedHandler stackTypedHandler, int slotIndex, int xPosition, int yPosition) {
        super(menu, stackTypedHandler, slotIndex, xPosition, yPosition);
    }

    public OrderedStackTypedSlot(BDBaseMenu menu, IStackTypedHandler stackTypedHandler, int slotIndex, int quickMoveSlotStartIndex, int quickMoveSlotEndIndex, int xPosition, int yPosition) {
        super(menu, stackTypedHandler, slotIndex, quickMoveSlotStartIndex, quickMoveSlotEndIndex, xPosition, yPosition);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public void click(IStackType clickStack, int button, Player player) {
        ItemStack carriedItem = this.menu.getCarried().copy();
        if (clickStack.isEmpty()) {
            if (!carriedItem.isEmpty()) {
                AtomicBoolean handled = new AtomicBoolean(false);
                if (carriedItem.getCount() == 1 && button == 1) {
                    Item item = carriedItem.getItem();
                    if (item instanceof BucketItem) {
                        FluidStackType stack;
                        FluidHandlerWrapper stackHandlerWrapper;
                        BucketItem bucketItem = (BucketItem)item;
                        Object handler = carriedItem.getCapability(Capabilities.FluidHandler.ITEM);
                        if (handler != null && (stackHandlerWrapper = new FluidHandlerWrapper(handler)).getSlots() > 0 && (stack = new FluidStackType(stackHandlerWrapper.getStackInSlot(0))) != null && !stack.isEmpty()) {
                            int changedCount = BDMath.clampLongToInt(Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize()));
                            int remaining = (int)this.storage.insert(this.getSlotIndex(), stack.copyWithCount(changedCount), true).getStackAmount();
                            if (remaining <= 0) {
                                this.storage.insert(this.getSlotIndex(), stack.copyWithCount(changedCount), false).getStackAmount();
                                this.menu.setCarried(new ItemStack((ItemLike)Items.BUCKET));
                                handled.set(true);
                            }
                        }
                    } else {
                        CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                            Function<?, IStackHandlerWrapper<?>> handlerGetter;
                            IStackHandlerWrapper<?> stackHandlerWrapper;
                            Object handler = carriedItem.getCapability(cap);
                            if (handler != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                                for (int index = 0; index < stackHandlerWrapper.getSlots(); ++index) {
                                    int remaining;
                                    int changedCount;
                                    int actualInsert;
                                    IStackType<?> stack = StackCreater.Create(typeId, stackHandlerWrapper.getStackInSlot(index));
                                    if (stack == null || stack.isEmpty() || (actualInsert = (changedCount = BDMath.clampLongToInt(Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize()))) - (remaining = (int)this.storage.insert(this.getSlotIndex(), stack.copyWithCount(changedCount), false).getStackAmount())) <= 0) continue;
                                    long actualExtracts = stackHandlerWrapper.extract(index, actualInsert, false);
                                    if (actualExtracts < (long)actualInsert) {
                                        this.storage.extract(this.getSlotIndex(), (long)actualInsert - actualExtracts, false);
                                    }
                                    this.menu.setCarried(carriedItem.copy());
                                    handled.set(true);
                                    break;
                                }
                            }
                        });
                    }
                }
                if (!handled.get()) {
                    int changedCount = button == 0 ? carriedItem.getCount() : 1;
                    int remaining = (int)this.storage.insert(this.getSlotIndex(), StackCreater.Create(ItemStackType.ID, carriedItem.copyWithCount(changedCount), changedCount), false).getStackAmount();
                    int actualInsert = changedCount - remaining;
                    int newCount = carriedItem.getCount() - actualInsert;
                    if (newCount <= 0) {
                        this.menu.setCarried(ItemStack.EMPTY);
                    } else {
                        ItemStack newCarriedItem = carriedItem.copy();
                        newCarriedItem.setCount(newCount);
                        this.menu.setCarried(newCarriedItem);
                    }
                }
            }
        } else if (this.mayPickup(player)) {
            if (carriedItem.isEmpty()) {
                if (clickStack instanceof ItemStackType) {
                    ItemStackType clickItem = (ItemStackType)clickStack;
                    int woundChangeNum = BDMath.clampLongToInt(Math.min(clickItem.getStackAmount(), clickItem.getVanillaMaxStackSize()));
                    int actualChangeNum = button == 0 ? woundChangeNum : (woundChangeNum + 1) / 2;
                    ItemStack takenItem = ((ItemStack)this.storage.extract(this.getSlotIndex(), actualChangeNum, false).getStack()).copy();
                    if (takenItem != null) {
                        this.menu.setCarried(takenItem);
                        this.storage.onChange();
                    }
                }
            } else if (this.mayPlace(carriedItem)) {
                if (clickStack.isSameTypeSameComponents(new ItemStackType(carriedItem.copy()))) {
                    int changedCount = button == 0 ? carriedItem.getCount() : 1;
                    int remaining = (int)this.storage.insert(this.getSlotIndex(), StackCreater.Create(ItemStackType.ID, carriedItem.copyWithCount(changedCount), changedCount), false).getStackAmount();
                    int actualInsert = changedCount - remaining;
                    int newCount = carriedItem.getCount() - actualInsert;
                    if (newCount <= 0) {
                        this.menu.setCarried(ItemStack.EMPTY);
                    } else {
                        ItemStack newCarriedItem = carriedItem.copy();
                        newCarriedItem.setCount(newCount);
                        this.menu.setCarried(newCarriedItem);
                    }
                } else if (carriedItem.getCount() == 1 && button == 1) {
                    Item remaining = carriedItem.getItem();
                    if (remaining instanceof BucketItem) {
                        BucketItem bucket = (BucketItem)remaining;
                        if (bucket == Items.BUCKET) {
                            FluidStackType fluidStackType;
                            Item filledBucket;
                            if (clickStack instanceof FluidStackType && (filledBucket = (fluidStackType = (FluidStackType)clickStack).getStack().getFluid().getBucket()) != null && filledBucket != Items.AIR && fluidStackType.getStackAmount() >= 1000L) {
                                this.storage.extract(this.getSlotIndex(), 1000L, false);
                                this.menu.setCarried(new ItemStack((ItemLike)filledBucket));
                            }
                        } else {
                            FluidStackType stack;
                            FluidHandlerWrapper stackHandlerWrapper;
                            Object handler = carriedItem.getCapability(Capabilities.FluidHandler.ITEM);
                            if (handler != null && (stackHandlerWrapper = new FluidHandlerWrapper(handler)).getSlots() > 0 && (stack = new FluidStackType(stackHandlerWrapper.getStackInSlot(0))) != null && !stack.isEmpty()) {
                                int changedCount = BDMath.clampLongToInt(Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize()));
                                int remaining2 = (int)this.storage.insert(this.getSlotIndex(), stack.copyWithCount(changedCount), true).getStackAmount();
                                if (remaining2 <= 0) {
                                    this.storage.insert(this.getSlotIndex(), stack.copyWithCount(changedCount), false).getStackAmount();
                                    this.menu.setCarried(new ItemStack((ItemLike)Items.BUCKET));
                                }
                            }
                        }
                    } else {
                        CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                            Function<?, IStackHandlerWrapper<?>> handlerGetter;
                            IStackHandlerWrapper<?> stackHandlerWrapper;
                            Object handler;
                            if (clickStack.getTypeId().equals(typeId) && (handler = carriedItem.getCapability(cap)) != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                                IStackType trueStack = this.storage.getStackBySlot(this.getSlotIndex());
                                long tureCount = 0L;
                                if (trueStack.isSameTypeSameComponents(clickStack)) {
                                    tureCount = trueStack.getStackAmount();
                                }
                                int changedCount = BDMath.clampLongToInt(Math.min(tureCount, clickStack.getVanillaMaxStackSize()));
                                int remaining = (int)stackHandlerWrapper.insert(clickStack.copyStack(), false);
                                int actualInsert = changedCount - remaining;
                                this.storage.extract(this.getSlotIndex(), actualInsert, false);
                                this.menu.setCarried(carriedItem.copy());
                            }
                        });
                    }
                }
            } else if (clickStack.isSameTypeSameComponents(new ItemStackType(carriedItem.copy()))) {
                // empty if block
            }
        }
    }

    @Override
    public void quickMove(IStackType clickStack, int button, Player player) {
        if (!clickStack.isEmpty()) {
            ItemStackType trueStack = this.storage.getStackBySlot(this.theSlot).copyWithCount(clickStack.getStackAmount());
            for (int targetSlotIndex = this.quickMoveSlotStartIndex; targetSlotIndex < this.quickMoveSlotEndIndex && !trueStack.isEmpty(); ++targetSlotIndex) {
                Slot slot = (Slot)this.menu.slots.get(targetSlotIndex);
                if (slot instanceof AbstractStackTypedSlot) {
                    AbstractStackTypedSlot aSlot = (AbstractStackTypedSlot)slot;
                    IStackType extract = this.safeExtract(trueStack);
                    IStackType remaining = aSlot.safeInsert(extract);
                    if (!remaining.isEmpty()) {
                        this.safeInsert(remaining);
                    }
                    trueStack = remaining.copy();
                    continue;
                }
                if (!(trueStack instanceof ItemStackType)) continue;
                ItemStackType trueItemTypedStack = trueStack;
                ItemStack extract = (ItemStack)this.safeExtract(trueItemTypedStack).getStack();
                ItemStack remaining = slot.safeInsert(extract);
                if (!remaining.isEmpty()) {
                    this.safeInsert(new ItemStackType(remaining));
                }
                trueStack = new ItemStackType(remaining.copy());
            }
            this.setChanged();
        }
    }

    @Override
    public IStackType safeInsert(IStackType stack) {
        if (stack != null) {
            return this.storage.insert(this.theSlot, stack, false);
        }
        return new ItemStackType();
    }

    @Override
    public IStackType safeExtract(IStackType stack) {
        if (stack != null && this.getStack() != null && stack.getTypeId().equals((Object)this.getStack().getTypeId()) && stack.isSameTypeSameComponents(this.getStack())) {
            return this.storage.extract(this.theSlot, stack.getStackAmount(), false);
        }
        return stack;
    }

    @Override
    public void updateChange() {
        IStackType currentStack = this.storage.getStackBySlot(this.getSlotIndex());
        if (currentStack == null) {
            this.lastStack = new ItemStackType();
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.menu.player), (CustomPacketPayload)new OrderedStackTypedSlotPacket(this.index, this.theSlot, this.lastStack, 0L), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (!(currentStack.isEmpty() && this.lastStack.isEmpty() || this.lastStack.getStackAmount() == currentStack.getStackAmount() && this.lastStack.getTypeId().equals((Object)currentStack.getTypeId()) && this.lastStack.isSameTypeSameComponents(currentStack))) {
            this.lastStack = currentStack;
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.menu.player), (CustomPacketPayload)new OrderedStackTypedSlotPacket(this.index, this.theSlot, this.lastStack, this.lastStack.getStackAmount()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void loadChange(int where, IStackType newStack, long newAmount) {
        this.storage.setStackDirectly(where, newStack);
    }
}

