/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Storage;

import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemUnifiedStorageHandler
implements IItemHandler {
    private UnifiedStorage storage;

    public ItemUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getSlots() {
        return this.storage.getTypeIdIndexList(ItemStackType.ID).map(list -> list.size() + 1).orElse(1);
    }

    public ItemStack getStackInSlot(int slot) {
        return this.storage.getTypeIdIndexList(ItemStackType.ID).filter(slots -> slot >= 0 && slot < slots.size()).map(slots -> (Integer)slots.get(slot)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (ItemStackType)this.storage.getStackBySlot((int)actualIndex)).map(ItemStackType::getStack).orElse(ItemStack.EMPTY);
    }

    public ItemStack insertItem(int slot, ItemStack itemStack, boolean sim) {
        ItemStackType typedStack = (ItemStackType)this.storage.insert(new ItemStackType(itemStack), sim);
        return typedStack.getStack();
    }

    public ItemStack extractItem(int slot, int count, boolean sim) {
        return (ItemStack)this.storage.extract(new ItemStackType(this.getStackInSlot(slot).copyWithCount(count)), sim).getStack();
    }

    public int getSlotLimit(int slot) {
        return 0x7FFFFFFE;
    }

    public boolean isItemValid(int slot, ItemStack itemStack) {
        return true;
    }
}

