/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.EMI.Recipe;

import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Packet.RecipeFillC2SPacket;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public class NetRecipeHandler
implements StandardRecipeHandler<DimensionsCraftMenu> {
    public List<Slot> getInputSources(DimensionsCraftMenu handler) {
        ArrayList<Slot> inputSlots = new ArrayList<Slot>();
        for (Slot slot : handler.slots) {
            if (slot instanceof ResultSlot || slot instanceof StoredStackSlot) continue;
            inputSlots.add(slot);
        }
        return inputSlots;
    }

    public List<Slot> getCraftingSlots(DimensionsCraftMenu handler) {
        ArrayList<Slot> craftingSlots = new ArrayList<Slot>();
        for (int i = handler.slots.size() - 9; i <= handler.slots.size() - 1; ++i) {
            craftingSlots.add((Slot)handler.slots.get(i));
        }
        return craftingSlots;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree();
    }

    public EmiPlayerInventory getInventory(AbstractContainerScreen<DimensionsCraftMenu> screen) {
        List stacks = this.getInputSources((DimensionsCraftMenu)screen.getMenu()).stream().map(Slot::getItem).map(EmiStack::of).collect(Collectors.toCollection(ArrayList::new));
        if (((DimensionsCraftMenu)screen.getMenu()).storage.getStorage() != null) {
            for (IStackType stackType : ((DimensionsCraftMenu)screen.getMenu()).storage.getStorage()) {
                ItemStackType itemStackType;
                if (!(stackType instanceof ItemStackType) || (itemStackType = (ItemStackType)stackType).isEmpty()) continue;
                stacks.add(EmiStack.of((ItemStack)itemStackType.getStack()));
            }
        }
        return new EmiPlayerInventory(stacks);
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<DimensionsCraftMenu> context) {
        Minecraft.getInstance().setScreen((Screen)context.getScreen());
        List inputs = recipe.getInputs();
        ArrayList<ItemStack> inputElements = new ArrayList<ItemStack>();
        DimensionsCraftMenu menu = (DimensionsCraftMenu)context.getScreen().getMenu();
        List<Slot> craftingSlots = this.getInputSources(menu);
        List<IStackType> storageSlots = menu.storage.getStorage();
        ArrayList<ItemStack> availableItems = new ArrayList<ItemStack>();
        for (Slot slot : craftingSlots) {
            if (!slot.hasItem()) continue;
            availableItems.add(slot.getItem().copy());
        }
        for (IStackType stackType : storageSlots) {
            ItemStackType itemStackType;
            ItemStack stack;
            if (!(stackType instanceof ItemStackType) || (stack = (itemStackType = (ItemStackType)stackType).getStack()).isEmpty()) continue;
            availableItems.add(stack.copy());
        }
        block2: for (EmiIngredient ingredient : inputs) {
            if (ingredient.isEmpty()) {
                inputElements.add(ItemStack.EMPTY);
                continue;
            }
            ArrayList<ItemStack> matching = new ArrayList<ItemStack>();
            for (ItemStack stack : availableItems) {
                if (stack.isEmpty() || !ingredient.getEmiStacks().stream().anyMatch(emiStack -> emiStack.getItemStack().getItem() == stack.getItem())) continue;
                matching.add(stack);
            }
            int required = (int)ingredient.getAmount();
            int available = matching.stream().mapToInt(ItemStack::getCount).sum();
            if (available >= required) {
                ItemStack merged = new ItemStack((ItemLike)((ItemStack)matching.get(0)).getItem(), required);
                inputElements.add(merged);
                int remaining = required;
                for (ItemStack stack : matching) {
                    int deduct = Math.min(remaining, stack.getCount());
                    stack.shrink(deduct);
                    if ((remaining -= deduct) > 0) continue;
                    continue block2;
                }
                continue;
            }
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"beyonddimensions.message.insufficient_materials"), true);
            return true;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new RecipeFillC2SPacket(inputElements), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }
}

