/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu.Slot;

import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenu;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.CommonHooks;

public class AutoRefillResultSlot
extends ResultSlot {
    private final CraftingContainer craftSlots;
    private final Player player;
    private DimensionsCraftMenu menu;

    public AutoRefillResultSlot(DimensionsCraftMenu menu, Player player, CraftingContainer craftSlots, Container container, int slot, int xPosition, int yPosition) {
        super(player, craftSlots, container, slot, xPosition, yPosition);
        this.menu = menu;
        this.player = player;
        this.craftSlots = craftSlots;
    }

    public void onTake(Player player, ItemStack stack) {
        this.checkTakeAchievements(stack);
        CraftingInput.Positioned positionedInput = this.craftSlots.asPositionedCraftInput();
        CraftingInput craftingGrid = positionedInput.input();
        int gridStartX = positionedInput.left();
        int gridStartY = positionedInput.top();
        CommonHooks.setCraftingPlayer((Player)player);
        NonNullList remainingItems = player.level().getRecipeManager().getRemainingItemsFor(RecipeType.CRAFTING, (RecipeInput)craftingGrid, player.level());
        CommonHooks.setCraftingPlayer(null);
        for (int gridRow = 0; gridRow < craftingGrid.height(); ++gridRow) {
            for (int gridCol = 0; gridCol < craftingGrid.width(); ++gridCol) {
                int slotIndex = gridCol + gridStartX + (gridRow + gridStartY) * this.craftSlots.getWidth();
                ItemStack slotStack = this.craftSlots.getItem(slotIndex);
                ItemStack recipeRemainder = (ItemStack)remainingItems.get(gridCol + gridRow * craftingGrid.width());
                if (!slotStack.isEmpty()) {
                    int itemsToRemove = 1;
                    if (slotStack.getCount() == 1) {
                        ItemStack singleItem = slotStack.copyWithCount(1);
                        boolean consumed = false;
                        long extracted = this.menu.storage.extract(new ItemStackType(singleItem), true).getStackAmount();
                        if (extracted >= 1L) {
                            if (!player.level().isClientSide()) {
                                this.menu.storage.extract(new ItemStackType(singleItem), false);
                            }
                            itemsToRemove = 0;
                            consumed = true;
                        }
                        if (!consumed) {
                            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                                ItemStack invStack = (ItemStack)player.getInventory().items.get(i);
                                if (!ItemStack.isSameItemSameComponents((ItemStack)invStack, (ItemStack)singleItem) || invStack.getCount() < 1) continue;
                                if (!player.level().isClientSide()) {
                                    invStack.shrink(1);
                                    player.getInventory().setItem(i, invStack.isEmpty() ? ItemStack.EMPTY : invStack);
                                }
                                itemsToRemove = 0;
                                consumed = true;
                                break;
                            }
                        }
                    }
                    if (itemsToRemove > 0) {
                        this.craftSlots.removeItem(slotIndex, itemsToRemove);
                    }
                    slotStack = this.craftSlots.getItem(slotIndex);
                }
                if (recipeRemainder.isEmpty()) continue;
                if (slotStack.isEmpty()) {
                    this.craftSlots.setItem(slotIndex, recipeRemainder);
                    continue;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)recipeRemainder)) {
                    recipeRemainder.grow(slotStack.getCount());
                    this.craftSlots.setItem(slotIndex, recipeRemainder);
                    continue;
                }
                if (this.player.getInventory().add(recipeRemainder)) continue;
                this.player.drop(recipeRemainder, false);
            }
        }
        DimensionsCraftMenu.slotChangedCraftingGrid(this.menu, player.level(), player, this.craftSlots, (ResultContainer)this.container, null, this.index);
    }
}

