/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network;

import com.mojang.logging.LogUtils;
import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenu;
import com.wintercogs.beyonddimensions.Menu.DimensionsNetMenu;
import com.wintercogs.beyonddimensions.Menu.NetControlMenu;
import com.wintercogs.beyonddimensions.Menu.NetEnergyMenu;
import com.wintercogs.beyonddimensions.Menu.NetInterfaceBaseMenu;
import com.wintercogs.beyonddimensions.Packet.CallServerPlayerInfoPacket;
import com.wintercogs.beyonddimensions.Packet.CallSeverClickPacket;
import com.wintercogs.beyonddimensions.Packet.CallSeverStoragePacket;
import com.wintercogs.beyonddimensions.Packet.ClickTransferCraftButtonPacket;
import com.wintercogs.beyonddimensions.Packet.EnergyStoragePacket;
import com.wintercogs.beyonddimensions.Packet.FlagSlotSetPacket;
import com.wintercogs.beyonddimensions.Packet.NetControlActionPacket;
import com.wintercogs.beyonddimensions.Packet.OpenNetGuiPacket;
import com.wintercogs.beyonddimensions.Packet.PlayerPermissionInfoPacket;
import com.wintercogs.beyonddimensions.Packet.PopModeButtonPacket;
import com.wintercogs.beyonddimensions.Packet.RecipeFillC2SPacket;
import com.wintercogs.beyonddimensions.Packet.StoragePacket;
import com.wintercogs.beyonddimensions.Packet.SyncFlagPacket;
import com.wintercogs.beyonddimensions.Packet.SyncStoragePacket;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.slf4j.Logger;

public class ServerPayloadHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleOpenNetGuiPacket(OpenNetGuiPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
            if (net != null) {
                LOGGER.info("\u73a9\u5bb6\u5b58\u5728\u7ef4\u5ea6\u7a7a\u95f4:{}\uff0c\u5c1d\u8bd5\u6253\u5f00GUI", (Object)net.getId());
                if (packet.isCraft()) {
                    context.player().openMenu((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, _player) -> new DimensionsCraftMenu(containerId, playerInventory, net), (Component)Component.translatable((String)"menu.title.beyonddimensions.dimensionnetmenu")));
                } else {
                    context.player().openMenu((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, _player) -> new DimensionsNetMenu(DimensionsNetMenu.Dimensions_Net_Menu.get(), containerId, playerInventory, net), (Component)Component.translatable((String)"menu.title.beyonddimensions.dimensionnetmenu")));
                }
            }
        });
    }

    public void handleItemStoragePacket(StoragePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleCallSeverStoragePacket(CallSeverStoragePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleSyncItemStoragePacket(SyncStoragePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleCallSeverClickPacket(CallSeverClickPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof DimensionsNetMenu) {
                DimensionsNetMenu menu = (DimensionsNetMenu)patt0$temp;
                menu.customClickHandler(packet.slotIndex(), packet.clickItem(), packet.button(), packet.shiftDown());
                menu.broadcastChanges();
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new CallSeverClickPacket(1, new ItemStackType(ItemStack.EMPTY), 1, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            AbstractContainerMenu patt1$temp = player.containerMenu;
            if (patt1$temp instanceof NetInterfaceBaseMenu) {
                NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)patt1$temp;
                menu.customClickHandler(packet.slotIndex(), packet.clickItem(), packet.button(), packet.shiftDown());
                menu.broadcastChanges();
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new CallSeverClickPacket(1, new ItemStackType(ItemStack.EMPTY), 1, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
        });
    }

    public void handleCallServerPlayerInfoPacket(CallServerPlayerInfoPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (!(player.containerMenu instanceof NetControlMenu)) {
                return;
            }
            NetControlMenu menu = (NetControlMenu)player.containerMenu;
            menu.sendPlayerInfo();
        });
    }

    public void handlePlayerPermissionInfoPacket(PlayerPermissionInfoPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleNetControlActionPacket(NetControlActionPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (!(player.containerMenu instanceof NetControlMenu)) {
                return;
            }
            NetControlMenu menu = (NetControlMenu)player.containerMenu;
            menu.handlePlayerAction(packet.receiver(), packet.action());
        });
    }

    public void handleSyncFlagPacket(SyncFlagPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (!(player.containerMenu instanceof NetInterfaceBaseMenu)) {
                return;
            }
            NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)player.containerMenu;
        });
    }

    public void handlePopModeButtonPacket(PopModeButtonPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof NetInterfaceBaseMenu) {
                NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)patt0$temp;
                menu.popMode = packet.popMode();
                menu.be.popMode = packet.popMode();
                return;
            }
            AbstractContainerMenu patt1$temp = player.containerMenu;
            if (patt1$temp instanceof NetEnergyMenu) {
                NetEnergyMenu menu = (NetEnergyMenu)patt1$temp;
                menu.popMode = packet.popMode();
                menu.be.popMode = packet.popMode();
                return;
            }
        });
    }

    public void handleFlagSlotSetPacket(FlagSlotSetPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof NetInterfaceBaseMenu) {
                NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)patt0$temp;
                menu.setFlagSlot(packet.index(), packet.clickStack(), packet.flagStack());
                menu.broadcastChanges();
                return;
            }
        });
    }

    public void handleEnergyStoragePacket(EnergyStoragePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleRecipeFillC2SPacket(RecipeFillC2SPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof DimensionsCraftMenu) {
                DimensionsCraftMenu menu = (DimensionsCraftMenu)patt0$temp;
                menu.transferRecipe(packet.inputs());
            }
        });
    }

    public void handleClickTransferCraftButtonPacket(ClickTransferCraftButtonPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof DimensionsCraftMenu) {
                DimensionsCraftMenu menu = (DimensionsCraftMenu)patt0$temp;
                menu.cleanCraftSlots(packet.toStorage());
            }
        });
    }
}

