/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public interface IStackTypedHandler {
    public List<IStackType> getStorage();

    public void onChange();

    public Object getTypedHandler(ResourceLocation var1);

    default public int getSlots() {
        return this.getStorage().size();
    }

    default public void clearStorage() {
        this.getStorage().clear();
    }

    default public IStackType getStackBySlot(int slot) {
        if (slot >= 0 && slot < this.getStorage().size()) {
            return this.getStorage().get(slot).copy();
        }
        return null;
    }

    default public IStackType getStackByStack(IStackType stackType) {
        for (IStackType existing : this.getStorage()) {
            if (!existing.getTypeId().equals((Object)stackType.getTypeId()) || !existing.isSameTypeSameComponents(stackType)) continue;
            return existing.copy();
        }
        return null;
    }

    default public boolean hasStackType(IStackType other) {
        return this.getStackByStack(other) != null;
    }

    default public void setStackDirectly(int slot, IStackType stack) {
        this.getStorage().set(slot, stack.copy());
        this.onChange();
    }

    default public void addStackToIndexDirectly(int slot, IStackType stack) {
        this.getStorage().add(slot, stack.copy());
        this.onChange();
    }

    default public void addStackDirectly(IStackType stack) {
        this.getStorage().add(stack.copy());
        this.onChange();
    }

    default public IStackType insert(int slot, IStackType stack, boolean simulate) {
        IStackType remaining;
        List<IStackType> storage = this.getStorage();
        if (slot < 0 || slot >= storage.size()) {
            return stack.copy();
        }
        if (!this.isStackValid(slot, stack) || stack.isEmpty()) {
            return stack.copy();
        }
        IStackType current = storage.get(slot);
        if (current == null || current.isEmpty()) {
            long maxInsert = Math.min(stack.getStackAmount(), this.getSlotCapacity(slot));
            if ((maxInsert = Math.min(maxInsert, stack.getVanillaMaxStackSize())) <= 0L) {
                return stack.copy();
            }
            remaining = stack.copyWithCount(stack.getStackAmount() - maxInsert);
            if (!simulate) {
                IStackType newStack = stack.copyWithCount(maxInsert);
                storage.set(slot, newStack);
                this.onChange();
            }
        } else {
            if (!current.isSameTypeSameComponents(stack)) {
                return stack.copy();
            }
            long slotCap = Math.min(this.getSlotCapacity(slot), stack.getVanillaMaxStackSize());
            long maxInsert = Math.min(stack.getStackAmount(), slotCap - current.getStackAmount());
            if (maxInsert <= 0L) {
                return stack.copy();
            }
            remaining = stack.copyWithCount(stack.getStackAmount() - maxInsert);
            if (!simulate) {
                current.grow(maxInsert);
                this.onChange();
            }
        }
        return remaining;
    }

    default public IStackType insert(IStackType stack, boolean simulate) {
        IStackType current;
        int slot;
        IStackType remaining = stack.copy();
        for (slot = 0; !(slot >= this.getSlots() || !(current = this.getStorage().get(slot)).isEmpty() && current.isSameTypeSameComponents(stack) && (remaining = this.insert(slot, remaining, simulate)).isEmpty()); ++slot) {
        }
        if (!remaining.isEmpty()) {
            for (slot = 0; !(slot >= this.getSlots() || (current = this.getStorage().get(slot)).isEmpty() && (remaining = this.insert(slot, remaining, simulate)).isEmpty()); ++slot) {
            }
        }
        return remaining;
    }

    default public IStackType extract(int slot, long count, boolean simulate) {
        List<IStackType> storage = this.getStorage();
        if (slot < 0 || slot >= storage.size()) {
            return new ItemStackType();
        }
        IStackType current = storage.get(slot);
        if (current.isEmpty()) {
            return current.getEmpty();
        }
        long extractable = Math.min(count, current.getStackAmount());
        IStackType extracted = current.copyWithCount(extractable);
        if (!simulate) {
            current.shrink(extractable);
            if (current.isEmpty()) {
                storage.set(slot, current.getEmpty());
            }
            this.onChange();
        }
        return extracted;
    }

    default public IStackType extract(IStackType stack, boolean simulate) {
        IStackType result = stack.getEmpty();
        long remaining = stack.getStackAmount();
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            IStackType extracted;
            long available;
            long toExtract;
            IStackType current = this.getStorage().get(slot);
            if (current.isEmpty() || !current.isSameTypeSameComponents(stack) || (toExtract = Math.min(remaining, available = current.getStackAmount())) <= 0L || (extracted = this.extract(slot, toExtract, simulate)).isEmpty()) continue;
            if (result.isEmpty()) {
                result = extracted;
            } else {
                result.grow(extracted.getStackAmount());
            }
            if ((remaining -= extracted.getStackAmount()) <= 0L) break;
        }
        return result.copyWithCount(stack.getStackAmount() - remaining);
    }

    public long getSlotCapacity(int var1);

    default public boolean isStackValid(int slot, IStackType stack) {
        return true;
    }

    public boolean isEmpty();
}

